(function (angular) {
    angular
        .module('retrospectiveApp')
        .factory('SubscribableService', SubscribableService);

    function SubscribableService() {
        /*
         Association between identifiers and the
         properties that the state object should contain as required
         */
        const propDictionary = {
            'participants': ['participants'],
            'stage': ['stage'],
            'moderator': ['moderator'],
            'completionDate': ['completionDate'],
            'ideas': ['ideas'],
            'isUserReady': ['ready'],
            'groupList': ['groupList'],
            'groupedIdea': ['groupedIdea'],
            'discussGroupIndex': ['index'],
            'settings': ['settings'],
            'totalVotes': ['totalVotes'],
            'sessionParticipants': ['participants'],
            'readOnlyMode':['readOnlyMode']
        };

        const voicemail = {};

        return {
            make
        };

        function make(scope) {
            scope.handlers = [];

            /*
             subscribe controllers to change in the events service

             handler: is jut a function to be called
             identifiers: an array containing ids that the handler should respond to
             */
            scope.subscribe = (handler, identifiers) => {
                if (!handler) {
                    throw new Error('No handler provided');
                }

                scope.handlers.push({
                    handler,
                    identifiers
                });

                identifiers.forEach((identifier) => {
                    (voicemail[identifier] || []).forEach((event) => {
                      handler(event);
                    });

                    //clear voice mail once the events were sent
                    //voicemail[identifier] = [];
                });
            };

            /*
             call to notify subscribers about a change

             model:

             {
                 identifier: String, // a key for the change so that controllers or services can identify it
                 state: Object // the information itself
             }
             */

            scope.notify = (event) => {
                if (!event.identifier || !event.state) {
                    throw new Error('Identifier or delta not provided');
                }

                /*
                    Since services will be expecting for an schema,
                    we should validate that the event's state contains some properties

                    these properties are defined in the object above this function
                 */
                const requiredProps = propDictionary[event.identifier];

                if (requiredProps.length) {
                    requiredProps.forEach((propName) => {
                       if (!event.state.hasOwnProperty(propName)) {
                           throw Error(`Property ${propName} is expected on state object`);
                       }
                    });
                }

                // pollers can start before the controller is subscribed to the tream
                // so let's create a a voice mail for these events
                if(!scope.handlers.length) {
                    voicemail[event.identifier] = voicemail[event.identifier] || [];
                    voicemail[event.identifier].push(event);
                }

                scope.handlers.forEach((item) => {
                    if (item.identifiers.indexOf(event.identifier) >= 0) {
                        item.handler(event);
                    }
                });
            };

        }
    }
}(angular));
