(function (angular) {
        angular
            .module('retrospectiveApp')
            .factory('HeartbeatPollerService', HeartbeatPollerService);

        HeartbeatPollerService.$inject = ['HTTP_PATH', '$http', '$window', '$interval', '$timeout'];

        function HeartbeatPollerService(HTTP_PATH, $http, $window, $interval, $timeout) {
            return Poller;

            function Poller(handler, sleep = 45000) {
                this.interval = null;
                this.resolved = true;

                this.start = (uuid, userKey, stopAfter = 0) => {
                    let counter = 0;
                    console.log('RETROSPECTIVES: Start retrospective heartbeat');

                    const resolver = (response, error) => {
                        if (error) {
                            console.log('Error while polling', error);
                        } else {
                            handler(response);
                        }

                        $timeout(() => {
                            this.resolved = true;
                        }, 100);

                        if (stopAfter) {
                            counter++;
                            if (counter == stopAfter) {
                                this.stop();
                            }
                        }
                    };

                    const poll = () => (
                        $http.post(`${HTTP_PATH}/workflow/heartbeat?uuid=${uuid}&userKey=${userKey}`)
                            .then(response => (resolver(response.data)))
                            .catch(err => (resolver(null, err)))
                    );

                    //call heartbeat so that the user is connected
                    poll();
                    this.interval = $interval(() => {
                        if (this.resolved) {
                            this.resolved = false;
                            poll();
                        }
                    }, sleep);
                };

                this.stop = () => {
                    console.log('RETROSPECTIVES: Stop poll READ ONLY MODE');
                    $interval.cancel(this.interval);
                };
            }
        }
    }(angular)
);