(function (angular) {
    angular.module('retrospectiveApp').service('EventService', EventService);

    EventService.$inject = ['HTTP_PATH', 'SERVLET_PATH', '$timeout', '$interval', '$http', 'DiscussService', 'VotesService', 'IdeasService', 'UserService', 'NotificationsService', 'WorkflowService'];

    function EventService(HTTP_PATH, SERVLET_PATH, $timeout, $interval, $http,
                          DiscussService, VotesService, IdeasService, UserService, NotificationsService,
                          WorkflowService) {


        this.init = ({userKey, uuid}) => {
            this.initEvents(uuid, userKey);
        };

        this.initEvents = (uuid, userKey) => {




            /*
             Will take care of:

             - groups (including action items and votes)
             */
            const groupsPoller = new Poller(`/topics?uuid=${uuid}`, (response) => {

            });


            /*
             just start pollers and let's start the party!
             */

            groupsPoller.start();

        };

        this.userKey = '';
        this.uuid = '';
        this.eventSource = {
            value: null
        };

        this.thinkState = {
            value: false
        };
        this.groupState = {
            value: false
        };
        this.voteState = {
            value: false
        };
        this.discussState = {
            value: false
        };
        this.isUserReady = {
            value: false
        };

        this.completionDate = {
            value: ''
        };

        this.activeUsers = [];
        this.moderator = {};
        this.activeView = {
            value: ''
        };

        this.loginStatus = {
            processCompleted: false,
            isValidSession: false
        };

        this.nextAvailable = {
            value: true
        };

        this.heartbeat = null;
        this.heartbeatSender = null;

        this.setModerator = user => {
            let prevMod = '';

            if (this.moderator && this.moderator.userKey !== user.userKey) {
                prevMod = `&prevMod=${this.moderator.userKey}`;
            }

            $http.put(`${HTTP_PATH}/workflow/set-moderator?userKey=${user.userKey}&uuid=${this.uuid}${prevMod}`).then(() => {
                this.moderator = Object.assign(this.moderator, user);
                const index = this.activeUsers.indexOf(user);

                if (this.activeUsers[index]) {
                    this.activeUsers[index].isModerator = true;
                    UserService.setModeratorByIndex(index);
                }
            });
        };

        this.changeHeaderState = current => {
            switch (current) {
                case 'think':
                    this.thinkState.value = true;
                    this.groupState.value = false;
                    this.voteState.value = false;
                    this.discussState.value = false;
                    break;
                case 'group':
                    this.thinkState.value = true;
                    this.groupState.value = true;
                    this.voteState.value = false;
                    this.discussState.value = false;
                    break;
                case 'vote':
                    this.thinkState.value = true;
                    this.groupState.value = true;
                    this.voteState.value = true;
                    this.discussState.value = false;
                    break;
                case 'discuss':
                    this.thinkState.value = true;
                    this.groupState.value = true;
                    this.voteState.value = true;
                    this.discussState.value = true;
                    break;
                case 'main':
                    this.thinkState.value = false;
                    this.groupState.value = false;
                    this.voteState.value = false;
                    this.discussState.value = false;
                    break;
            }
        };

        this.changeView = current => {
            if (this.activeView.value == current) {
                return;
            }

            this.nextAvailable.value = false;
            $http.put(`${HTTP_PATH}/workflow/change-view?userKey=${this.userKey}&uuid=${this.uuid}&viewName=${current}`).then((response) => {
                if (response.data.completionDate) {
                    this.completionDate.value = response.data.completionDate;
                }
                this.activeView.value = current;
                this.changeHeaderState(current);
                this.nextAvailable.value = true;
            });
        };

        const selfLoginEvent = result => {
            UserService.setUserList([].concat(result));

            this.activeUsers.length = 0;

            UserService.getUserList().forEach(u => {
                this.activeUsers.push(u);
            });
        };

        const changeIdeaEvent = result => {

            for (var key in result.ideasMap) {
                if (result.ideasMap.hasOwnProperty(key)) {
                    IdeasService.setList(result.ideasMap[key], key);
                }
            }
            IdeasService.notify();
        };

        const newUserEvent = user => {
            const containsUser = this.activeUsers.find((activeUser) => activeUser.userKey == user.userKey);

            if (!containsUser) {
                this.activeUsers.push(user);
                UserService.setUserList(this.activeUsers.slice());
            }
        };

        const disconnectedUserEvent = disconnectedUser => {
            this.activeUsers.forEach((user, index) => {
                if (user.userKey === disconnectedUser.userKey) {
                    this.activeUsers.splice(index, 1);
                }
            });

            UserService.setUserList(this.activeUsers.slice());
            const text = `${disconnectedUser.fullName} has left the session.`;
            NotificationsService.sendNotification('', text);
        };

        const newModeratorEvent = moderator => {
            this.moderator = Object.assign(this.moderator, moderator);

            this.activeUsers.forEach(user => {
                user.isModerator = user.userKey === moderator.userKey;
            });

            if (this.moderator.userKey === this.userKey) {
                const text = 'You are the new Moderator of this Retro. You can transfer this role in the dropdown menu.';
                NotificationsService.sendNotification('Congratulations!', text, 'success');
            } else {
                const text = `has been successfully named Moderator.`;
                NotificationsService.sendNotification(this.moderator.fullName, text, 'success');
            }
        };

        const updateImReady = user => {
            this.activeUsers.forEach(u => {
                if (u.userKey === user.userKey) {
                    u.isReady = user.isReady;
                }
            });

            if (this.moderator && this.moderator.userKey === user.userKey) {
                this.moderator.isReady = user.isReady;
            }
        };

        const resetImReady = () => {
            this.activeUsers.forEach(user => {
                user.isReady = false;
            });

            if (this.moderator) {
                this.moderator.isReady = false;
            }

            this.isUserReady.value = false;
        };

        const groupIdeaEvent = result => {
            IdeasService.setGroupsList(result.groupCollection);
            IdeasService.setGroupedIdea(result.groupedIdea);
            IdeasService.setDragIdeasEnabled(result.dragIdeasEnabled);
            IdeasService.notify();
        };

        const newGroupEvent = result => {
            IdeasService.setGroupsList(result.groupCollection);
            IdeasService.setGroupedIdea(undefined);
            IdeasService.setDragIdeasEnabled(result.dragIdeasEnabled);
            IdeasService.notify();
        };

        const changeViewEvent = result => {
            this.changeView(result.viewName);
        };

        const newVoteEvent = vote => {
            VotesService.insertVote(vote);
            VotesService.notify();
        };

        const actionItemEvent = groupElement => {
            DiscussService.updateGroupElement(groupElement);
            DiscussService.setIndex(undefined);
            DiscussService.notify();
        };

        const changeTopicEvent = index => {
            DiscussService.setIndex(index);
            DiscussService.notify();
        };

        const syncView = data => {
            if (data.viewName && data.viewName != this.activeView.value) {
                this.activeView.value = data.viewName;
            }
        };

        const digest = (fn) => (event) => {
            $timeout(() => {
                try {
                    const data = JSON.parse(event.data);
                    fn(data);
                } catch (err) {
                    fn({});
                }
            }, 0);
        };

        const persistData = () => $http.post(`${HTTP_PATH}/workflow/persist/all?uuid=${this.uuid}`);

        const loginProcessCompletedEvent = (data) => {
            this.loginStatus.processCompleted = true;
            this.loginStatus.isValidSession = data.validSession;

            if (!data.validSession) {
                this.eventSource.value.close();

                if (this.heartbeat) {
                    $interval.cancel(this.heartbeat);
                    $interval.cancel(this.heartbeatSender);
                }
            }
        };

        this.init = ({userKey, uuid, completionDate}) => {
            this.userKey = userKey;
            this.uuid = uuid;
            this.completionDate.value = completionDate;

            this.eventSource.value = new EventSource(`${SERVLET_PATH}/plugins/servlet/sse?userKey=${userKey}&uuid=${uuid}`);

            this.eventSource.onerror = () => {
                console.log('EventSource failed.');
            };

            let secondsConnecting = 0;

            this.heartbeat = $interval(() => {
                if (this.eventSource.value.readyState == 1) {
                    secondsConnecting = 0;
                    this.loginStatus.processCompleted = true;
                    return;
                }

                if (this.eventSource.value.readyState != 1) {
                    secondsConnecting++;
                }

                if (secondsConnecting >= 20) {
                    this.loginStatus.processCompleted = true;
                    this.loginStatus.isValidSession = false;
                    this.eventSource.value.close();
                    this.eventSource.value = new EventSource(`${SERVLET_PATH}/plugins/servlet/sse?userKey=${userKey}&uuid=${uuid}`);
                    //$interval.cancel(this.heartbeat);
                    //$interval.cancel(this.heartbeatSender);
                }
            }, 1000);

            const time = Math.round(5000 + Math.random() * 5000);
            const time2 = Math.round(2000 + Math.random() * 5000);

            $timeout(() => {
                this.heartbeatSender = $interval(() => {
                    $http.get(`${HTTP_PATH}/workflow/heartbeat?uuid=${this.uuid}&ts=${Date.now()}`);
                }, time2);
            }, time);

            this.persistData = persistData;
            this.initEvents();
        };

        this.initEvents = () => {
            this.eventSource.value.addEventListener('SELF_LOGIN', digest(selfLoginEvent));
            this.eventSource.value.addEventListener('NEW_IDEA', digest(changeIdeaEvent));

            this.eventSource.value.addEventListener('DELETE_IDEA', digest(changeIdeaEvent));
            this.eventSource.value.addEventListener('NEW_USER', digest(newUserEvent));
            this.eventSource.value.addEventListener('DISCONNECTED_USER', digest(disconnectedUserEvent));
            this.eventSource.value.addEventListener('NEW_MODERATOR', digest(newModeratorEvent));
            this.eventSource.value.addEventListener('ERROR', digest(console.error));
            this.eventSource.value.addEventListener('IM_READY', digest(updateImReady));
            this.eventSource.value.addEventListener('RESET_IM_READY', digest(resetImReady));
            this.eventSource.value.addEventListener('GROUP_IDEA', digest(groupIdeaEvent));
            this.eventSource.value.addEventListener('NEW_GROUP', digest(newGroupEvent));
            this.eventSource.value.addEventListener('CHANGE_VIEW', digest(changeViewEvent));
            this.eventSource.value.addEventListener('NEW_VOTE', digest(newVoteEvent));
            this.eventSource.value.addEventListener('ACTION_ITEM', digest(actionItemEvent));
            this.eventSource.value.addEventListener('CHANGE_TOPIC', digest(changeTopicEvent));
            this.eventSource.value.addEventListener('SYNC_VIEW', digest(syncView));
            this.eventSource.value.addEventListener('LOGIN_PROCESS', digest(loginProcessCompletedEvent));
        };
    }
}(angular));