(function (angular) {
  angular.module("retrospectiveApp").service("DiscussService", DiscussService);

  DiscussService.$inject = [
    "HTTP_PATH",
    "$http",
    "SubscribableService",
    "StatefulService",
    "PollerService",
    "UtilService",
  ];

  function DiscussService(
    HTTP_PATH,
    $http,
    Subscribable,
    Stateful,
    Poller,
    UtilService
  ) {
    Subscribable.make(this);

    Stateful.make(this, {
      allowNull: false,
      allowUndefined: false,
    });

    this.groupsPoller = null;

    this.stopPoller = () => {
      if (!this.groupsPoller) {
        return;
      }
      this.groupsPoller.stop();
      this.groupsPoller = null;
    };

    this.startPollers = (userKey, uuid, interval, stopAfter) => {
      if (this.groupsPoller) {
        return;
      }

      this.state.set("userKey", userKey);
      this.state.set("uuid", uuid);

      this.groupsPoller = new Poller(
        `/group?uuid=${this.state.get("uuid")}`,
        (response) => {
          if (!response.data) {
            return;
          }

          //remove group with ungrouped ideas (empty)
          response.data.groupList.splice(0, 1);

          this.notify({
            identifier: "groupList",
            state: {
              groupList: response.data.groupList
                .map((item) => {
                  if (!item.ideas) {
                    item.ideas = [];
                  }
                  item.ideas = item.ideas.map((idea) => {
                    idea.idea = UtilService.decodeHTML(idea.idea);
                    return idea;
                  });
                  return item;
                })
                .sort((a, b) => {
                  /*
                            if the groups have different votes, we'll order them based on the votes
                            otherwise, we'll order based on the id
                             */
                  if (b.votes != a.votes) {
                    return b.votes - a.votes;
                  } else {
                    return b.id - a.id;
                  }
                }),
            },
          });
        },
        interval
      );

      this.groupsPoller.start(stopAfter);
    };

    this.addActionItem = (groupId, actionItem) =>
      $http
        .post(
          `${HTTP_PATH}/group/${groupId}/actionitems?userKey=${this.state.get(
            "userKey"
          )}&uuid=${this.state.get("uuid")}`,
          actionItem
        )
        .then(() => this.groupsPoller.poll());

    this.removeActionItem = (groupId, actionItemId) =>
      $http
        .delete(
          `${HTTP_PATH}/group/${groupId}/actionitems/${actionItemId}?userKey=${this.state.get(
            "userKey"
          )}&uuid=${this.state.get("uuid")}`
        )
        .then(() => this.groupsPoller.poll());

    this.setAssignee = (groupId, actionItemId, user) => {
      user.imageURI = user.imageUri;
      delete user.imageUri;
      delete user.isConnected;
      delete user.id;
      return $http
        .put(
          `${HTTP_PATH}/group/${groupId}/actionitems/${actionItemId}/assignee?uuid=${this.state.get(
            "uuid"
          )}`,
          user
        )
        .then(() => this.groupsPoller.poll());
    };

    this.toggleComplete = (groupId, actionItemId) => {
      return $http
        .put(
          `${HTTP_PATH}/group/${groupId}/actionitems/${actionItemId}/togglecomplete?userKey=${this.state.get(
            "userKey"
          )}&uuid=${this.state.get("uuid")}`
        )
        .then(() => this.groupsPoller.poll());
    };

    this.clearAssignee = (groupId, actionItemId) =>
      $http
        .delete(
          `${HTTP_PATH}/group/${groupId}/actionitems/${actionItemId}/assignee?uuid=${this.state.get(
            "uuid"
          )}`
        )
        .then(() => this.groupsPoller.poll());

    this.nextTopic = () =>
      $http.put(
        `${HTTP_PATH}/workflow/nexttopic?userKey=${this.state.get(
          "userKey"
        )}&uuid=${this.state.get("uuid")}`
      );

    this.previousTopic = () =>
      $http.put(
        `${HTTP_PATH}/workflow/previoustopic?userKey=${this.state.get(
          "userKey"
        )}&uuid=${this.state.get("uuid")}`
      );
  }
})(angular);
