function tryGetBaseForExport() {
    var baseUrl = window.location.origin + window.location.pathname;

    if (baseUrl.indexOf('/plugins') >= 0) {
        return baseUrl.split('/plugins')[0];
    }
    // we'll use default value
    else {
        return '';
    }
}

function exportData() {
    var baseUrl = tryGetBaseForExport();
    var url = baseUrl + '/rest/retrospective/latest/workflow/export';

    $.ajax({
        url: url,
        success: function(response) {
            var time = (new Date()).getTime();
            var data = "text/json;charset=utf-8," + encodeURIComponent(JSON.stringify({retros: response}));
            var $element = $('<a class="button" href="data:' + data + '" download="data.json">Download!</a>');
            $element.appendTo('#button-container');
            $('button').css('display', 'none');
        }
    });
}
