(function(angular){
    angular
        .module('retrospectiveApp')
        .directive('tooltipDirective', tooltipDirective);

    tooltipDirective.$inject = [
        "UtilService",
    ];

    function tooltipDirective(UtilService) {
        const link = (scope, element) => {
            element.attr("data-placement", "bottom");
            element.attr('data-html', 'true');

            element.on('mouseenter', () => {
                if (scope.$parent.vm.isCurrentUserMod && scope.$parent.vm.isCurrentUserMod()) {
                    element.attr('title', DOMPurify.sanitize(UtilService.encodeHTML(scope.modTitle)));
                } else {
                    element.attr('title', DOMPurify.sanitize(UtilService.encodeHTML(scope.userTitle)));
                }

                if ((scope.visible == undefined || scope.visible) && ( element.attr('title') != undefined && element.attr('title').length > 0) )
                    $(element).tooltip('show');
                else
                    element.attr('title', '');
            });

            element.on('mouseleave', () => {
                $(element).tooltip('destroy');
            });
        };

        return {
            restrict: 'A',
            scope: {
                modTitle: '=',
                userTitle: '=',
                visible: '='
            },
            link
        };
    }
}(angular));