(function (angular) {
    console.rlog = (...args) => {
        console.log('AGILE RETROSPECTIVES', ...args);
    };

    angular
        .module('retrospectiveApp', ['dndLists'])
        .config(($httpProvider) => {
            /**
             * interceptor to log response time
             */
            //$httpProvider.interceptors.push('performanceTracker');

            //initialize get if not there
            if (!$httpProvider.defaults.headers.get) {
                $httpProvider.defaults.headers.get = {};
            }

            // Answer edited to include suggestions from comments
            // because previous version of code introduced browser-related errors

            //disable IE ajax request caching
            $httpProvider.defaults.headers.get['If-Modified-Since'] = 'Mon, 26 Jul 1997 05:00:00 GMT';
            // extra
            $httpProvider.defaults.headers.get['Cache-Control'] = 'no-cache';
            $httpProvider.defaults.headers.get['Pragma'] = 'no-cache';

            $httpProvider.defaults.headers.common['X-Atlassian-Token'] = 'no-check';
            $httpProvider.defaults.headers.common['Content-Type'] = 'application/json';

            $httpProvider.interceptors.push(['$q', function ($q) {
                return {
                    'responseError': function (rejection) {
                        if (rejection.status === 403 && rejection.data.message === 'PERMISSION_REVOKED') {
                            $('#permissions-revoked-modal').modal({backdrop: 'static', show: true});
                        }
                        return $q.reject(rejection);
                    }
                };
            }]);
        });
}(angular));