export type WizardData = {
    backlogName: string;
    cardset: string;
    defaultResult: string;
    editSettingsAvailable: boolean;
};

class WizardModel {
    private data:WizardData;

    constructor() {
        this.data = {
            backlogName: '',
            cardset: '',
            defaultResult: '',
            editSettingsAvailable: false
        };
    }

    setEditSettingsAvailable(available: boolean): void {
        this.data.editSettingsAvailable = available;
    }

    getEditSettingsAvailable(): boolean {
        return this.data.editSettingsAvailable;
    }

    setBacklogName(name:string):void {
        this.data.backlogName = name;
    }

    getBacklogName():string {
        return this.data.backlogName;
    }

    setCardset(cardset:string):void {
        this.data.cardset = cardset;
    }

    getCardset():string {
        return this.data.cardset;
    }

    setDefaultResult(defaultResult:string):void {
        this.data.defaultResult = defaultResult;
    }

    getDefaultResult():string {
        return this.data.defaultResult || "AVERAGE";
    }

    clear():void {
        this.data = null;
    }
}

const wizardModel = new WizardModel();
export default wizardModel;
