declare const aui: any;
declare const AJS: any;

type dialogOptions = {
    size: string,
    titleText: string,
    content: string,
    id: string,
    modal: boolean,
    footerActionContent: string
};

type dialogOptionParams = {
    size?: string,
    titleText: string,
    content: string,
    modal?: boolean,
    footerActionContent: string
};

const defaultOptions = {
    size: 'xlarge',
    modal: true,
};

class Dialog {
    public options: dialogOptions;
    public $element: JQuery;

    constructor(public macroName: string, options: dialogOptionParams) {
        this.options = {...options, ...defaultOptions, id: macroName};
        console.log(this.options);
        const dialogTemplate = aui.dialog.dialog2(this.options);
        this.$element = $(dialogTemplate).appendTo($('body'));
    }

    show() {
        AJS.dialog2(`[id='${this.options.id}']`).show();
    }

    hide() {
        AJS.dialog2(`[id='${this.options.id}']`).hide();
    }
}

export default Dialog;