/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.gson.Gson;
import com.nearsoft.retrospective.mappers.GroupElementMapper;
import com.nearsoft.retrospective.mappers.VoteElementMapper;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.VoteRequest;
import com.nearsoft.retrospective.model.entity.GroupElementEntity;
import com.nearsoft.retrospective.model.entity.VoteEntity;
import com.nearsoft.retrospective.service.GroupsInSessionService;
import com.nearsoft.retrospective.service.QueryHelper;
import com.nearsoft.retrospective.service.SettingsService;
import com.nearsoft.retrospective.service.response.wrappers.VoteResponse;
import java.util.ArrayList;
import net.java.ao.DBParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoteService {
    private final ActiveObjects activeObjects;
    private final SettingsService settingsService;
    private static final Gson GSON = new Gson();
    private final GroupsInSessionService groupsInSessionMap;

    @Autowired
    public VoteService(@ComponentImport ActiveObjects activeObjects, SettingsService settingsService, GroupsInSessionService groupsInSessionService) {
        this.activeObjects = activeObjects;
        this.settingsService = settingsService;
        this.groupsInSessionMap = groupsInSessionService;
    }

    public GroupsInSessionService getGroupsInSessionMap() {
        return this.groupsInSessionMap;
    }

    private DatabaseType DATABASE_TYPE() {
        return this.activeObjects.moduleMetaData().getDatabaseType();
    }

    public void initializeForSession(long uuid) {
        GroupElementEntity[] groupsInPage = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ByPageId(uuid));
        ArrayList<Integer> groupsInSession = this.groupsInSessionMap.getOrDefault(uuid, new ArrayList<Integer>());
        for (GroupElementEntity groupInPage : groupsInPage) {
            groupsInSession.add(groupInPage.getID());
        }
        this.groupsInSessionMap.put(uuid, groupsInSession);
    }

    public void finalizeForSession(long uuid) {
        GroupElementEntity[] groupsInPage;
        for (GroupElementEntity g2 : groupsInPage = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ByPageId(uuid))) {
            GroupElement groupElement = GroupElementMapper.map(g2);
            int votes = 0;
            for (VoteEntity v : g2.getVoteList()) {
                votes += v.getVotes();
            }
            g2.setVotes(votes);
            g2.setUserKeys(GSON.toJson(groupElement.getVotesPerUser().keySet()));
            g2.setVotesPerUser(GSON.toJson(groupElement.getVotesPerUser()));
            g2.save();
        }
        this.groupsInSessionMap.remove(uuid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VoteResponse vote(long uuid, VoteRequest request, boolean increased, final String userKey) throws Exception {
        int groupId = request.getGroup().getId();
        final GroupElementEntity votedGroupEntity = (GroupElementEntity)this.activeObjects.get(GroupElementEntity.class, (Object)groupId);
        GroupElement votedGroupElement = GroupElementMapper.map(votedGroupEntity);
        if (!this.groupsInSessionMap.containsKey(uuid)) {
            this.initializeForSession(uuid);
        }
        RetrosSettings retrosSettings = this.settingsService.getRetrosSettingsById(uuid);
        VoteEntity currentVote = (VoteEntity)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<VoteEntity>(){

            public VoteEntity doInTransaction() {
                VoteEntity[] votedEntity = (VoteEntity[])VoteService.this.activeObjects.find(VoteEntity.class, QueryHelper.byGroupIdAndUserKey(votedGroupEntity.getID(), userKey, VoteService.this.DATABASE_TYPE()));
                VoteEntity currentVote = null;
                if (votedEntity == null || votedEntity.length < 1) {
                    currentVote = (VoteEntity)VoteService.this.activeObjects.create(VoteEntity.class, new DBParam[0]);
                    currentVote.setGroup(votedGroupEntity);
                    currentVote.setUserKey(userKey);
                    currentVote.setVotes(0);
                    currentVote.save();
                } else {
                    currentVote = votedEntity[0];
                }
                return currentVote;
            }
        });
        Integer votes = currentVote.getVotes();
        if ((votes = Integer.valueOf(votes + (increased ? 1 : -1))) < 0) {
            return new VoteResponse(false, "Trying to decrease while vote is zero");
        }
        int globalVotes = 0;
        for (Integer currentGroupId : this.groupsInSessionMap.get(uuid)) {
            VoteEntity[] voteForThisGroup = (VoteEntity[])this.activeObjects.find(VoteEntity.class, QueryHelper.byGroupIdAndUserKey(currentGroupId, userKey, this.DATABASE_TYPE()));
            if (voteForThisGroup == null || voteForThisGroup.length < 1) {
                globalVotes += 0;
                continue;
            }
            globalVotes += voteForThisGroup[0].getVotes();
        }
        if (increased) {
            if (retrosSettings.getVotesPerPlayer() == 0 && retrosSettings.getVotesAllowedPerCard() == 0) {
                currentVote.setVotes(votes);
                this.updateVoteEntity(currentVote);
            } else if (retrosSettings.getVotesPerPlayer() == 0 && votes <= retrosSettings.getVotesAllowedPerCard()) {
                currentVote.setVotes(votes);
                this.updateVoteEntity(currentVote);
            } else if (globalVotes + 1 <= retrosSettings.getVotesPerPlayer() && retrosSettings.getVotesAllowedPerCard() == 0) {
                currentVote.setVotes(votes);
                this.updateVoteEntity(currentVote);
            } else {
                if (globalVotes + 1 > retrosSettings.getVotesPerPlayer() || votes > retrosSettings.getVotesAllowedPerCard()) return new VoteResponse(false, "Vote limit reached. Max votes per player: " + retrosSettings.getVotesPerPlayer() + " Max votes per card: " + retrosSettings.getVotesAllowedPerCard() + " Per player: " + globalVotes + " Per card: " + votes);
                currentVote.setVotes(votes);
                this.updateVoteEntity(currentVote);
            }
        } else {
            currentVote.setVotes(votes);
            this.updateVoteEntity(currentVote);
        }
        votedGroupElement.getVoteList().add(VoteElementMapper.map(currentVote));
        votedGroupEntity.save();
        return new VoteResponse(true, "OK");
    }

    private void updateVoteEntity(final VoteEntity vote) {
        this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<VoteEntity>(){

            public VoteEntity doInTransaction() {
                vote.save();
                return vote;
            }
        });
    }
}

