/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.nearsoft.retrospective.mappers.ThinkElementMapper;
import com.nearsoft.retrospective.mappers.UserMapper;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.SessionData;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.model.entity.ThinkElementEntity;
import com.nearsoft.retrospective.model.entity.UserEntity;
import com.nearsoft.retrospective.service.QueryHelper;
import com.nearsoft.retrospective.service.RetrospectiveUserService;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.SettingsService;
import com.nearsoft.retrospective.util.enumerations.ViewName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.RawEntity;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThinkService {
    private final ActiveObjects activeObjects;
    private final RetrospectiveUserService retrospectiveUserService;
    private final SessionDataService sessionDataService;
    private final SettingsService settingsService;

    @Autowired
    public ThinkService(@ComponentImport ActiveObjects activeObjects, RetrospectiveUserService retrospectiveUserService, SessionDataService sessionDataService, SettingsService settingsService) {
        this.activeObjects = activeObjects;
        this.retrospectiveUserService = retrospectiveUserService;
        this.sessionDataService = sessionDataService;
        this.settingsService = settingsService;
    }

    private DatabaseType DATABASE_TYPE() {
        return this.activeObjects.moduleMetaData().getDatabaseType();
    }

    public void insertIdea(long uuid, String textIdea, User user, String columnId) {
        ThinkElement thinkElement = new ThinkElement(textIdea, user, columnId);
        thinkElement.setEditable(true);
        ThinkElementEntity entity = ThinkElementMapper.map(thinkElement, this.activeObjects, null, uuid);
        entity.save();
    }

    public void deleteIdea(Integer ideaId, String userKey) {
        ThinkElementEntity[] thinkElementEntities = (ThinkElementEntity[])this.activeObjects.find(ThinkElementEntity.class, QueryHelper.ById(ideaId.intValue()));
        if (thinkElementEntities != null && thinkElementEntities.length > 0) {
            Arrays.stream(thinkElementEntities).forEach(entity -> {
                UserEntity userEntity = entity.getUser();
                User user = UserMapper.map(userEntity);
                if (user.getUserKey().equals(userKey)) {
                    this.activeObjects.delete(new RawEntity[]{entity});
                }
            });
        }
    }

    public void deleteThinkElementByPageId(int pageId) {
        ThinkElementEntity[] thinkElementEntities = (ThinkElementEntity[])this.activeObjects.find(ThinkElementEntity.class, QueryHelper.ByPageId(pageId));
        Arrays.stream(thinkElementEntities).forEach(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    public List<ThinkElement> getThinkElementsList(long uuid) {
        ArrayList<ThinkElement> thinkElementList = new ArrayList<ThinkElement>(0);
        ThinkElementEntity[] thinkElementEntities = this.getThinkElementsByPageId(uuid);
        SessionData sessionData = this.sessionDataService.getSessionDataByUUID(uuid);
        RetrosSettings retrosSettings = this.settingsService.getRetrosSettingsById(uuid);
        String currentUserKey = this.retrospectiveUserService.getCurrentUserKey();
        for (ThinkElementEntity thinkElementEntity : thinkElementEntities) {
            if (thinkElementEntity == null) continue;
            ThinkElement thinkElement = ThinkElementMapper.map(thinkElementEntity, retrosSettings, currentUserKey);
            thinkElement.setId(thinkElementEntity.getID());
            if (sessionData.getViewName().equals(ViewName.THINK.getValue())) {
                this.setHiddenIdeaForNoOwners(thinkElement, currentUserKey);
            }
            thinkElementList.add(thinkElement);
        }
        return thinkElementList;
    }

    public ThinkElementEntity[] getThinkElementsByPageId(long pageId) {
        return (ThinkElementEntity[])this.activeObjects.find(ThinkElementEntity.class, QueryHelper.ByPageId(pageId));
    }

    public void updateThinkElement(int ideaId, String idea, String userKey) {
        ThinkElementEntity[] ideas = (ThinkElementEntity[])this.activeObjects.find(ThinkElementEntity.class, QueryHelper.ById(ideaId));
        if (ideas != null && ideas.length > 0) {
            ThinkElementEntity foundIdea = ideas[0];
            UserEntity userEntity = foundIdea.getUser();
            User user = UserMapper.map(userEntity);
            if (foundIdea.getEditable() && user.getUserKey().equals(userKey)) {
                foundIdea.setIdea(idea);
                foundIdea.save();
            }
        }
    }

    private void setHiddenIdeaForNoOwners(ThinkElement thinkElement, String currentUserKey) {
        if (!thinkElement.getUser().getUserKey().equals(currentUserKey)) {
            thinkElement.setIdea(RandomStringUtils.randomAlphabetic(10));
        }
    }
}

