/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.nearsoft.retrospective.dto.Format;
import com.nearsoft.retrospective.dto.FormatColumn;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.mappers.RetroSettingsMapper;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.ConfluenceTasks;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.RetrosColumn;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.model.entity.FormatColumnEntity;
import com.nearsoft.retrospective.model.entity.FormatEntity;
import com.nearsoft.retrospective.model.entity.RetrosColumnEntity;
import com.nearsoft.retrospective.model.entity.RetrosSettingsEntity;
import com.nearsoft.retrospective.model.entity.RetrosSettingsTemplateEntity;
import com.nearsoft.retrospective.model.entity.SessionDataEntity;
import com.nearsoft.retrospective.service.GroupService;
import com.nearsoft.retrospective.service.QueryHelper;
import com.nearsoft.retrospective.service.RetrospectiveUserService;
import com.nearsoft.retrospective.util.DateUtil;
import com.nearsoft.retrospective.util.enumerations.ViewName;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SettingsService {
    private static final Logger LOGGER = Logger.getLogger((String)SettingsService.class.getName());
    private final ActiveObjects activeObjects;
    private final RetrospectiveUserService _retrospectiveUserService;
    @ConfluenceImport
    private final ContentService contentService;
    private final GroupService groupService;

    @Autowired
    public SettingsService(@ComponentImport ActiveObjects activeObjects, RetrospectiveUserService retrospectiveUserService, ContentService contentService, GroupService groupService) {
        this.activeObjects = activeObjects;
        this._retrospectiveUserService = retrospectiveUserService;
        this.contentService = contentService;
        this.groupService = groupService;
    }

    public RetrosSettingsEntity createAndSaveRetrosSettings(int votesPerPlayer, int votesPerCard, boolean anonymousIdeas, String presetModeratorUserKey, boolean isTemplate, Integer formatId, String spaceKey) throws Exception {
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.create(RetrosSettingsEntity.class, new DBParam[0]);
        String currentUserKey = this._retrospectiveUserService.getCurrentUserKey();
        if (currentUserKey == null || currentUserKey.isEmpty()) {
            LOGGER.warn((Object)"The current user key is null or empty at SettingsService#createAndSaveRetrosSettings");
            throw new Exception("Empty current user key");
        }
        retrosSettingsEntity.setCreatorUserKey(currentUserKey);
        retrosSettingsEntity.setAnonymousPlayersAllowed(anonymousIdeas);
        retrosSettingsEntity.setVotesAllowedPerCard(votesPerCard);
        retrosSettingsEntity.setVotesPerPlayer(votesPerPlayer);
        retrosSettingsEntity.setPresetModeratorUserKey(presetModeratorUserKey);
        retrosSettingsEntity.setIsTemplate(isTemplate);
        FormatEntity formatEntity = (FormatEntity)this.activeObjects.get(FormatEntity.class, (Object)formatId);
        if (formatEntity == null) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        retrosSettingsEntity.setFormat(formatEntity);
        retrosSettingsEntity.setSpaceKey(spaceKey);
        retrosSettingsEntity.save();
        return retrosSettingsEntity;
    }

    public Long searchRetroTemplate(long pageId, long templateId) {
        RetrosSettingsTemplateEntity[] retroTemplate = (RetrosSettingsTemplateEntity[])this.activeObjects.find(RetrosSettingsTemplateEntity.class, QueryHelper.ByPageIdAndTemplateId(pageId, templateId));
        if (retroTemplate.length == 0) {
            return null;
        }
        return retroTemplate[0].getRetroId();
    }

    public void saveRetroTemplate(long pageId, long uuid, long uuidTemplate) {
        RetrosSettingsTemplateEntity retrosTemplate = (RetrosSettingsTemplateEntity)this.activeObjects.create(RetrosSettingsTemplateEntity.class, new DBParam[0]);
        retrosTemplate.setUuidTemplate(uuidTemplate);
        retrosTemplate.setRetroId(uuid);
        retrosTemplate.setPageId(pageId);
        retrosTemplate.save();
    }

    public RetrosColumnEntity saveAndCreateRetrosColumn(RetrosSettingsEntity retrosSettingsEntity, String content, String color, String columnId) {
        RetrosColumnEntity retrosColumnEntity = (RetrosColumnEntity)this.activeObjects.create(RetrosColumnEntity.class, new DBParam[0]);
        retrosColumnEntity.setColumnId(columnId);
        retrosColumnEntity.setContent(content);
        retrosColumnEntity.setColor(color);
        retrosColumnEntity.setSettingsEntity(retrosSettingsEntity);
        retrosColumnEntity.save();
        return retrosColumnEntity;
    }

    private RetrosSettings getDefaultSettings() {
        RetrosSettings settings = new RetrosSettings();
        ArrayList<RetrosColumn> columns = new ArrayList<RetrosColumn>();
        RetrosColumn columnWell = new RetrosColumn();
        columnWell.setColumnId("C1");
        columnWell.setContent("What went well?");
        columnWell.setColor("#7ED321");
        columns.add(columnWell);
        RetrosColumn columnWrong = new RetrosColumn();
        columnWrong.setColumnId("C2");
        columnWrong.setContent("What didn't go well?");
        columnWrong.setColor("#D0021B");
        columns.add(columnWrong);
        settings.setColumns(columns.toArray(new RetrosColumn[columns.size()]));
        settings.setCreatorUserKey("");
        return settings;
    }

    public RetrosSettings getRetrosSettingsById(long id) {
        RetrosSettingsEntity[] retrosSettingsResult = (RetrosSettingsEntity[])this.activeObjects.find(RetrosSettingsEntity.class, QueryHelper.ById(id));
        if (retrosSettingsResult.length == 0) {
            return this.getDefaultSettings();
        }
        return RetroSettingsMapper.map(retrosSettingsResult[0]);
    }

    public boolean updatePresetModeratorForRetrosSettingsById(long id, String newPresetModeratorUserKey) {
        RetrosSettingsEntity[] retrosSettingsResult = (RetrosSettingsEntity[])this.activeObjects.find(RetrosSettingsEntity.class, QueryHelper.ById(id));
        if (retrosSettingsResult.length > 0) {
            RetrosSettingsEntity settingsEntity = retrosSettingsResult[0];
            if (!settingsEntity.getPresetModeratorUserKey().equals("RETROS_DYNAMIC_MODERATOR")) {
                settingsEntity.setPresetModeratorUserKey(newPresetModeratorUserKey);
                settingsEntity.save();
                return true;
            }
            return false;
        }
        return false;
    }

    public Format[] getFormats() {
        FormatEntity[] formatEntities = (FormatEntity[])this.activeObjects.find(FormatEntity.class);
        Format[] formats = new Format[formatEntities.length];
        for (int i = 0; i < formatEntities.length; ++i) {
            int formatId = formatEntities[i].getID();
            FormatColumnEntity[] columnEntities = formatEntities[i].getFormatColumns();
            FormatColumn[] formatColumns = new FormatColumn[columnEntities.length];
            String formatName = formatEntities[i].getName();
            for (int j = 0; j < columnEntities.length; ++j) {
                String content = columnEntities[j].getContent();
                String color = columnEntities[j].getColor();
                formatColumns[j] = new FormatColumn(content, color);
            }
            formats[i] = new Format(formatId, formatName, formatColumns);
        }
        return formats;
    }

    public List<RetrosSettings> getAllRetros() {
        return (List)this.activeObjects.executeInTransaction(() -> {
            RetrosSettingsEntity[] retrosSettingsResult = (RetrosSettingsEntity[])this.activeObjects.find(RetrosSettingsEntity.class);
            ArrayList allMappedRetros = new ArrayList();
            if (retrosSettingsResult.length > 0) {
                Arrays.stream(retrosSettingsResult).forEach(retroEntity -> allMappedRetros.add(RetroSettingsMapper.map(retroEntity)));
            }
            return allMappedRetros;
        });
    }

    public void initSettings(int settingsId, long pageId) throws FourHundredException {
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.get(RetrosSettingsEntity.class, (Object)settingsId);
        if (retrosSettingsEntity == null) {
            RetrosSettingsEntity[] retrosSettingsArrayEntity = (RetrosSettingsEntity[])this.activeObjects.find(RetrosSettingsEntity.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
            if (retrosSettingsArrayEntity.length == 0) {
                return;
            }
            retrosSettingsEntity = retrosSettingsArrayEntity[0];
        }
        if (retrosSettingsEntity.getPageId() != null) {
            return;
        }
        Content page = (Content)this.contentService.find(new Expansion[]{new Expansion("space")}).withType(new ContentType[]{ContentType.PAGE}).withId(ContentId.of((long)pageId), new ContentId[0]).fetchOrNull();
        if (page == null) {
            return;
        }
        if (retrosSettingsEntity.getSpaceKey() == null) {
            retrosSettingsEntity.setSpaceKey(page.getSpace().getKey());
        }
        if (!retrosSettingsEntity.getSpaceKey().equals(page.getSpace().getKey())) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        retrosSettingsEntity.setPageId(page.getId().asLong());
        retrosSettingsEntity.save();
    }

    public ConfluenceTasks getConfluenceTasks(int retroId, long pageId, String columnId, String criteria, List<ThinkElement> ideas) throws FourHundredException {
        String completionDate;
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.get(RetrosSettingsEntity.class, (Object)retroId);
        if (retrosSettingsEntity == null) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        if (retrosSettingsEntity.getColumns() == null) {
            throw new FourHundredException(Response.Status.CONFLICT);
        }
        Optional<RetrosColumnEntity> retrosColumnEntityOptional = Arrays.stream(retrosSettingsEntity.getColumns()).filter(retrosColumnEntity -> retrosColumnEntity != null && retrosColumnEntity.getColumnId() != null && retrosColumnEntity.getColumnId().equals(columnId)).findFirst();
        if (!retrosColumnEntityOptional.isPresent()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        SessionDataEntity[] sessionDataEntities = (SessionDataEntity[])this.activeObjects.executeInTransaction(() -> (SessionDataEntity[])this.activeObjects.find(SessionDataEntity.class, QueryHelper.ByPageId(retroId)));
        if (sessionDataEntities.length == 0) {
            throw new FourHundredException(Response.Status.CONFLICT);
        }
        SessionDataEntity sessionDataEntity = sessionDataEntities[0];
        if (sessionDataEntity.getViewName() == null || !sessionDataEntity.getViewName().equals(ViewName.RESULT.getValue())) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        RetrosColumnEntity retrosColumnEntity2 = retrosColumnEntityOptional.get();
        List<GroupElement> groupList = this.groupService.getGroupsByPageId(retroId, ideas).getGroupList();
        List actionItemList = groupList.stream().filter(groupElement -> groupElement.getIdeas() != null && groupElement.getIdeas().get(0).getColumnId().equals(columnId) && groupElement.getActionItems() != null).flatMap(groupElement -> groupElement.getActionItems().stream().filter(this.getActionItemCriteriaPredicate(criteria))).collect(Collectors.toList());
        String listElements = actionItemList.stream().map(actionItem -> {
            Object mention = "";
            User assigneeUser = actionItem.getAssigneeUser();
            if (assigneeUser != null) {
                mention = "<a userkey=\"" + assigneeUser.getUserKey() + "\" data-linked-resource-type=\"userinfo\" data-linked-resource-default-alias=\"" + assigneeUser.getUserName() + "\" class=\"confluence-link\">" + assigneeUser.getUserName() + "</a>";
            }
            String classCheck = actionItem.getComplete() ? "class=\"checked\"" : "";
            return "<li data-inline-task-id=\"\" " + classCheck + ">" + actionItem.getDescription() + "&nbsp;\ufeff" + (String)mention + "</li>";
        }).collect(Collectors.joining());
        try {
            completionDate = DateUtil.stringDateChangeFormat("yyyy/MM/dd HH:mm:ss", sessionDataEntity.getCompletionDate(), "dd/MMMM/YYYY");
        }
        catch (ParseException e) {
            completionDate = DateUtil.stringFormat(new Date(), "dd/MMMM/YYYY");
        }
        String taskContentBuilder = "<h2><span>Action items for the Retrospective session of " + completionDate + "</span></h2><h3><span>" + retrosColumnEntity2.getContent() + "</span></h3><ul class=\"inline-task-list\" data-inline-tasks-content-id=\"" + pageId + "\">" + listElements + "</ul>";
        ConfluenceTasks confluenceTasks = new ConfluenceTasks();
        confluenceTasks.setContent(taskContentBuilder);
        return confluenceTasks;
    }

    private Predicate<ActionItem> getActionItemCriteriaPredicate(String criteria) {
        switch (criteria) {
            case "all": {
                return actionItem -> true;
            }
            case "onlyResolved": {
                return ActionItem::getComplete;
            }
            case "onlyUnresolved": {
                return actionItem -> !actionItem.getComplete();
            }
            case "onlyUnassigned": {
                return actionItem -> actionItem.getAssigneeUser() == null;
            }
        }
        return actionItem -> actionItem.getAssigneeUser() != null && actionItem.getAssigneeUser().getUserKey() != null && actionItem.getAssigneeUser().getUserKey().equals(criteria);
    }
}

