/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.spi.DatabaseType;
import java.util.Date;
import net.java.ao.Query;

public class QueryHelper {
    public static Query ByPageIdAndTemplateId(long pageId, long templateId) {
        return Query.select().where("PAGE_ID = ? AND UUID_TEMPLATE = ?", new Object[]{pageId, templateId});
    }

    public static Query ByPageId(long pageId) {
        return Query.select().where("NUMERIC_PAGE_ID = ?", new Object[]{pageId});
    }

    public static Query ByUUID(long uuid) {
        return Query.select().where("NUMERIC_UUID = ?", new Object[]{uuid});
    }

    public static Query ByPageIdAndUserKey(long pageId, String userKey, DatabaseType databaseType) {
        if (databaseType == DatabaseType.MS_SQL) {
            return Query.select().where("NUMERIC_PAGE_ID = ? and cast(USER_KEY as nvarchar(100)) = ?", new Object[]{pageId, userKey});
        }
        if (databaseType == DatabaseType.ORACLE) {
            return Query.select().where("NUMERIC_PAGE_ID = ? and to_char(USER_KEY) = ?", new Object[]{pageId, userKey});
        }
        return Query.select().where("NUMERIC_PAGE_ID = ? and USER_KEY = ?", new Object[]{pageId, userKey});
    }

    public static Query ByUserKey(String userKey, DatabaseType databaseType) {
        if (databaseType == DatabaseType.MS_SQL) {
            return Query.select().where("cast(USER_KEY as nvarchar(100)) = ?", new Object[]{userKey});
        }
        if (databaseType == DatabaseType.ORACLE) {
            return Query.select().where("to_char(USER_KEY) = ?", new Object[]{userKey});
        }
        return Query.select().where("USER_KEY = ?", new Object[]{userKey});
    }

    public static Query ById(long id) {
        return Query.select().where("ID = ?", new Object[]{id});
    }

    public static Query byGroupIdAndUserKey(int groupId, String userKey, DatabaseType databaseType) {
        if (databaseType == DatabaseType.MS_SQL) {
            return Query.select().where("GROUP_ID = ? and cast(USER_KEY as nvarchar(100)) = ?", new Object[]{groupId, userKey});
        }
        if (databaseType == DatabaseType.ORACLE) {
            return Query.select().where("GROUP_ID = ? and to_char(USER_KEY) = ?", new Object[]{groupId, userKey});
        }
        return Query.select().where("GROUP_ID = ? and USER_KEY = ?", new Object[]{groupId, userKey});
    }

    public static Query ByPageIdAndLastSeen(long pageId) {
        Date now = new Date();
        now.setMinutes(now.getMinutes() - 1);
        now.setSeconds(now.getSeconds() - 30);
        return Query.select().where("NUMERIC_PAGE_ID = ? and LAST_SEEN > ?", new Object[]{pageId, now.getTime()});
    }
}

