/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.nearsoft.retrospective.model.entity.GroupsInSessionEntity;
import com.nearsoft.retrospective.service.QueryHelper;
import com.nearsoft.retrospective.service.intf.GroupsMapInterface;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupsInSessionService
implements GroupsMapInterface {
    private final ActiveObjects _activeObjects;

    @Autowired
    public GroupsInSessionService(@ComponentImport ActiveObjects activeObjects) {
        this._activeObjects = activeObjects;
    }

    private DatabaseType DATABASE_TYPE() {
        return this._activeObjects.moduleMetaData().getDatabaseType();
    }

    @Override
    public ArrayList<Integer> get(long uuid) throws Exception {
        String[] idsString;
        GroupsInSessionEntity[] entites = (GroupsInSessionEntity[])this._activeObjects.find(GroupsInSessionEntity.class, QueryHelper.ByUUID(uuid));
        if (entites == null || entites.length == 0) {
            throw new Exception("Unexpected empty list");
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (String anIdsString : idsString = entites[0].getGroupIds().split(",")) {
            ids.add(Integer.parseInt(anIdsString));
        }
        return ids;
    }

    @Override
    public ArrayList<Integer> getOrDefault(long uuid, ArrayList<Integer> defaultValue) {
        try {
            return this.get(uuid);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public void put(long uuid, ArrayList<Integer> newValue) {
        String commaSeparated = newValue.stream().map(Object::toString).collect(Collectors.joining(","));
        GroupsInSessionEntity[] entities = (GroupsInSessionEntity[])this._activeObjects.find(GroupsInSessionEntity.class, QueryHelper.ByUUID(uuid));
        if (entities == null || entities.length == 0) {
            GroupsInSessionEntity entity = (GroupsInSessionEntity)this._activeObjects.create(GroupsInSessionEntity.class, new DBParam[0]);
            entity.setUuid("" + uuid);
            entity.setNumericUUID(uuid);
            entity.setGroupIds(commaSeparated);
            entity.save();
            return;
        }
        GroupsInSessionEntity entity = entities[0];
        entity.setGroupIds(commaSeparated);
        entity.save();
    }

    @Override
    public void remove(long uuid) {
        GroupsInSessionEntity[] entities = (GroupsInSessionEntity[])this._activeObjects.find(GroupsInSessionEntity.class, QueryHelper.ByUUID(uuid));
        this._activeObjects.delete((RawEntity[])entities);
    }

    @Override
    public boolean containsKey(long uuid) {
        GroupsInSessionEntity[] entites = (GroupsInSessionEntity[])this._activeObjects.find(GroupsInSessionEntity.class, QueryHelper.ByUUID(uuid));
        return entites != null && entites.length != 0;
    }
}

