/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.securityControl;

import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.service.RetrospectiveUserService;
import com.nearsoft.retrospective.service.SettingsService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreatorValidator {
    private final SettingsService _settingsService;
    private final RetrospectiveUserService _retrospectiveUserService;

    @Autowired
    public CreatorValidator(SettingsService settingsService, RetrospectiveUserService retrospectiveUserService) {
        this._settingsService = settingsService;
        this._retrospectiveUserService = retrospectiveUserService;
    }

    public boolean isUserCreatorForRetro(long uuid, String userKey) {
        RetrosSettings retrosSettings = this._settingsService.getRetrosSettingsById(uuid);
        if (StringUtils.isBlank((CharSequence)retrosSettings.getCreatorUserKey())) {
            return true;
        }
        String creatorUserKey = retrosSettings.getCreatorUserKey();
        return creatorUserKey.equals(userKey);
    }

    public boolean isCurrentUserCreatorForRetro(long uuid) {
        return this.isUserCreatorForRetro(uuid, this._retrospectiveUserService.getCurrentUserKey());
    }
}

