/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.model.entity.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.nearsoft.retrospective.model.entity.GroupElementEntity;
import com.nearsoft.retrospective.model.entity.VoteEntity;
import java.util.HashMap;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class VoteEntityUpgrade_v19
implements ActiveObjectsUpgradeTask {
    private final int BATCH_SIZE = 100;

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"19");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        Gson GSON = new Gson();
        activeObjects.flushAll();
        activeObjects.migrate(new Class[]{VoteEntity.class, GroupElementEntity.class});
        int size = activeObjects.count(GroupElementEntity.class);
        if (size == 0) {
            return;
        }
        int iterations = (int)Math.ceil((double)size / 100.0);
        if (iterations == 0) {
            iterations = 1;
        }
        for (int i = 0; i < iterations; ++i) {
            GroupElementEntity[] groups;
            for (GroupElementEntity groupElementEntity : groups = (GroupElementEntity[])activeObjects.find(GroupElementEntity.class, Query.select().limit(100).offset(i * 100))) {
                try {
                    if (groupElementEntity.getVotesPerUser() != null && !groupElementEntity.getVotesPerUser().isEmpty()) {
                        HashMap parsedVotesPerUser = (HashMap)GSON.fromJson(groupElementEntity.getVotesPerUser(), new TypeToken<HashMap<String, Integer>>(){}.getType());
                        for (String userKey : parsedVotesPerUser.keySet()) {
                            VoteEntity voteEntity = (VoteEntity)activeObjects.create(VoteEntity.class, new DBParam[0]);
                            voteEntity.setUserKey(userKey);
                            voteEntity.setGroup(groupElementEntity);
                            voteEntity.setVotes((Integer)parsedVotesPerUser.get(userKey));
                            voteEntity.save();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                groups = null;
            }
        }
    }
}

