/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.model;

import com.nearsoft.retrospective.model.RetrosColumn;
import com.nearsoft.retrospective.model.ThinkElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThinkCollection {
    private Map<String, List<ThinkElement>> ideasMap = new HashMap<String, List<ThinkElement>>();

    public void deleteIdea(int index, String columnId) {
        this.ideasMap.get(columnId).remove(index);
    }

    public void addIdea(ThinkElement idea) {
        this.ideasMap.get(idea.getColumnId()).add(idea);
    }

    public List<ThinkElement> getIdeasByColumnId(String columnId) {
        return this.ideasMap.get(columnId);
    }

    public void setIdeas(List<ThinkElement> ideas) {
        for (ThinkElement thinkElement : ideas) {
            this.addIdea(thinkElement);
        }
    }

    public List<ThinkElement> getAllIdeas() {
        ArrayList<ThinkElement> thinkElements = new ArrayList<ThinkElement>();
        for (String columnId : this.ideasMap.keySet()) {
            thinkElements.addAll((Collection<ThinkElement>)this.ideasMap.get(columnId));
        }
        return thinkElements;
    }

    public void setColumns(RetrosColumn[] columns) {
        for (RetrosColumn column : columns) {
            this.ideasMap.put(column.getColumnId(), new ArrayList());
        }
    }
}

