/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.mappers;

import com.nearsoft.retrospective.model.RetrosColumn;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.entity.FormatEntity;
import com.nearsoft.retrospective.model.entity.RetrosColumnEntity;
import com.nearsoft.retrospective.model.entity.RetrosSettingsEntity;
import java.util.ArrayList;
import java.util.Arrays;

public class RetroSettingsMapper {
    public static RetrosSettings map(RetrosSettingsEntity entity) {
        RetrosSettings settings = new RetrosSettings();
        ArrayList<RetrosColumn> columns = new ArrayList<RetrosColumn>();
        for (RetrosColumnEntity rc : entity.getColumns()) {
            RetrosColumn column = new RetrosColumn();
            column.setContent(rc.getContent());
            column.setColor(rc.getColor());
            column.setColumnId(rc.getColumnId());
            columns.add(column);
        }
        RetrosColumn[] columnsArray = columns.toArray(new RetrosColumn[columns.size()]);
        Arrays.sort(columnsArray, (o1, o2) -> Integer.parseInt(o1.getColumnId().replace("C", "")) - Integer.parseInt(o2.getColumnId().replace("C", "")));
        settings.setColumns(columnsArray);
        settings.setVotesPerPlayer(entity.getVotesPerPlayer());
        settings.setVotesAllowedPerCard(entity.getVotesAllowedPerCard());
        settings.setAnonymousPlayersAllowed(entity.getAnonymousPlayersAllowed());
        settings.setPresetModeratorUserKey(entity.getPresetModeratorUserKey());
        settings.setIsTemplate(entity.getIsTemplate());
        settings.setId(entity.getID());
        FormatEntity formatEntity = entity.getFormat();
        if (formatEntity == null) {
            settings.setFormatId(null);
        } else {
            settings.setFormatId(entity.getFormat().getID());
        }
        settings.setCreatorUserKey(entity.getCreatorUserKey());
        return settings;
    }
}

