/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.mappers;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.GroupedIdea;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.entity.GroupedIdeaEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.java.ao.DBParam;

public class GroupedIdeaMapper {
    public static GroupElement map(GroupedIdea groupedIdea, ThinkElement[] thinkElements) {
        String[] ids = groupedIdea.getThinkElementIds();
        ArrayList<ThinkElement> ideasInGroup = new ArrayList<ThinkElement>();
        block0: for (String id : ids) {
            if (id.isEmpty()) continue;
            int ideaId = Integer.parseInt(id);
            for (ThinkElement thinkElement : thinkElements) {
                if (ideaId != thinkElement.getId()) continue;
                ideasInGroup.add(thinkElement);
                continue block0;
            }
        }
        GroupElement groupElement = new GroupElement();
        groupElement.setGrouped(true);
        groupElement.setIdeas(ideasInGroup);
        groupElement.setActionItems(new ArrayList<ActionItem>());
        if (groupedIdea.getName().equals("Untitled group")) {
            groupElement.setDescription("");
        } else {
            groupElement.setDescription(groupedIdea.getName());
        }
        groupElement.setUserKeys(new HashSet<String>());
        groupElement.setVotes(0);
        groupElement.setVotesPerUser(new HashMap<String, Integer>());
        return groupElement;
    }

    public static GroupedIdea map(GroupedIdeaEntity groupedIdeaEntity) {
        GroupedIdea groupedIdea = new GroupedIdea();
        groupedIdea.setName(groupedIdeaEntity.getName());
        groupedIdea.setColumnId(groupedIdeaEntity.getColumnId());
        String thinkElementIds = groupedIdeaEntity.getThinkElementIds();
        if (thinkElementIds == null) {
            thinkElementIds = "";
        }
        String[] thinkElementIdsArray = thinkElementIds.split(",");
        groupedIdea.setThinkElementIds(thinkElementIdsArray);
        groupedIdea.setUuid(groupedIdeaEntity.getUuid());
        groupedIdea.setNumericUUID(groupedIdeaEntity.getNumericUUID());
        groupedIdea.setGroupId(groupedIdeaEntity.getGroupId());
        return groupedIdea;
    }

    public static GroupedIdeaEntity map(GroupedIdea groupedIdea, ActiveObjects activeObjects) {
        GroupedIdeaEntity groupedIdeaEntity = (GroupedIdeaEntity)activeObjects.create(GroupedIdeaEntity.class, new DBParam[0]);
        groupedIdeaEntity.setColumnId(groupedIdea.getColumnId());
        groupedIdeaEntity.setName(groupedIdea.getName());
        StringBuilder commaSeparated = new StringBuilder("");
        for (String id : groupedIdea.getThinkElementIds()) {
            commaSeparated.append(id).append(",");
        }
        String finalCommaSeparated = commaSeparated.length() == 0 ? commaSeparated.toString() : commaSeparated.deleteCharAt(commaSeparated.length() - 1).toString();
        groupedIdeaEntity.setThinkElementIds(finalCommaSeparated);
        groupedIdeaEntity.setUuid(groupedIdea.getUuid());
        groupedIdeaEntity.setNumericUUID(groupedIdea.getNumericUUID());
        groupedIdeaEntity.setGroupId(groupedIdea.getGroupId());
        groupedIdeaEntity.save();
        return groupedIdeaEntity;
    }
}

