/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.mappers;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.nearsoft.retrospective.mappers.ActionItemMapper;
import com.nearsoft.retrospective.mappers.ThinkElementMapper;
import com.nearsoft.retrospective.mappers.VoteElementMapper;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.VoteElement;
import com.nearsoft.retrospective.model.entity.GroupElementEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.java.ao.DBParam;

public class GroupElementMapper {
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = Logger.getLogger(GroupElementMapper.class.getName());

    public static GroupElement map(GroupElementEntity groupElementEntity) {
        List<ThinkElement> mappedIdeas = new ArrayList<ThinkElement>();
        if (groupElementEntity.getIdeas() != null && groupElementEntity.getIdeas().length > 0) {
            mappedIdeas = Arrays.stream(groupElementEntity.getIdeas()).map(ThinkElementMapper::map).collect(Collectors.toList());
        }
        String description = groupElementEntity.getDescription();
        GroupElement groupElement = new GroupElement(description, mappedIdeas);
        ArrayList<ActionItem> mappedActionItems = new ArrayList();
        if (groupElement.getActionItems() != null && groupElement.getActionItems().size() > 0) {
            mappedActionItems = Arrays.stream(groupElementEntity.getActionItems()).map(ActionItemMapper::map).collect(Collectors.toList());
        }
        HashSet<String> userKeys = new HashSet();
        try {
            Set parsedUserKeys = (Set)GSON.fromJson(groupElementEntity.getUserKeys(), new TypeToken<HashSet<String>>(){}.getType());
            if (parsedUserKeys != null) {
                userKeys = parsedUserKeys;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Could not parse " + groupElementEntity.getUserKeys() + " to Set");
            LOGGER.warning("Using default empty list");
        }
        HashMap<String, Integer> votesPerUser = new HashMap<String, Integer>();
        ArrayList<VoteElement> voteList = new ArrayList();
        if (groupElementEntity.getVoteList() != null && groupElementEntity.getVoteList().length > 0) {
            voteList = Arrays.stream(groupElementEntity.getVoteList()).map(VoteElementMapper::map).collect(Collectors.toList());
        }
        groupElement.setActionItems(mappedActionItems);
        groupElement.setGrouped(groupElementEntity.getGrouped());
        groupElement.setVotes(groupElementEntity.getVotes());
        groupElement.setUserKeys(userKeys);
        groupElement.setVotesPerUser(votesPerUser);
        groupElement.setVoteList(voteList);
        return groupElement;
    }

    public static GroupElementEntity map(long uuid, GroupElement groupElement, ActiveObjects activeObjects) {
        GroupElementEntity entity = (GroupElementEntity)activeObjects.create(GroupElementEntity.class, new DBParam[0]);
        entity.setNumericPageId(uuid);
        entity.setPageId("" + uuid);
        entity.setDescription(groupElement.getDescription());
        entity.setGrouped(groupElement.isGrouped());
        entity.setUserKeys(GSON.toJson(groupElement.getUserKeys()));
        entity.setVotes(groupElement.getVotes());
        entity.setVotesPerUser(GSON.toJson(groupElement.getVotesPerUser()));
        entity.save();
        return entity;
    }
}

