/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.listener;

import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.SettingsService;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserJoinListener
implements DisposableBean {
    private static final Logger LOGGER = Logger.getLogger(UserJoinListener.class.getName());
    private static final String MACRO_NAME = "agile Retrospectives for Confluence";
    private final SessionDataService sessionDataService;
    private final EventPublisher eventPublisher;
    private final UserAccessor userAccessor;
    private final SettingsService settingsService;

    @Autowired
    public UserJoinListener(@ComponentImport EventPublisher eventPublisher, @ComponentImport UserAccessor userAccessor, SessionDataService sessionDataService, SettingsService settingsService) {
        this.userAccessor = userAccessor;
        this.eventPublisher = eventPublisher;
        this.sessionDataService = sessionDataService;
        this.settingsService = settingsService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void userJoinEvent(PageViewEvent event) {
        if (this.isMacroInPage(event)) {
            Long[] macroUUIDs = this.searchForMacroUUIDs(event);
            long key = event.getPage().getId();
            for (Long macroUUID : macroUUIDs) {
                Long retroTemplateId = this.settingsService.searchRetroTemplate(key, macroUUID);
                if (retroTemplateId != null) {
                    this.addParticipant(retroTemplateId);
                    continue;
                }
                this.addParticipant(macroUUID);
            }
            if (macroUUIDs.length == 0) {
                this.addParticipant(key);
            }
        }
    }

    private void addParticipant(long key) {
        this.sessionDataService.getSessionDataByUUID(key);
        ConfluenceUserImpl confluenceUser = this.getConfluenceUser();
        this.sessionDataService.getUserByPageIdOrCreate(key);
        this.sessionDataService.setUserAsConnected(confluenceUser.getKey().getStringValue(), key);
    }

    Long[] searchForMacroUUIDs(PageViewEvent event) {
        String pageContent = this.getPageContent(event);
        boolean containsUuid = pageContent.contains("agile-retrospectives-for-confluence-uuid");
        if (!containsUuid) {
            return null;
        }
        Pattern patt = Pattern.compile("<ac:parameter ac:name=\"agile-retrospectives-for-confluence-uuid\">([0-9]*)</ac:parameter>");
        Matcher matcher = patt.matcher(pageContent);
        ArrayList<Long> uuids = new ArrayList<Long>();
        try {
            while (matcher.find()) {
                uuids.add(Long.parseLong(matcher.group(1)));
            }
        }
        catch (Exception ex) {
            LOGGER.warning(ex.getMessage());
        }
        return uuids.toArray(new Long[uuids.size()]);
    }

    String getPageContent(PageViewEvent event) {
        return event.getPage().getBodyContent().getBody();
    }

    boolean isMacroInPage(PageViewEvent event) {
        return this.getPageContent(event).contains(MACRO_NAME);
    }

    ConfluenceUserImpl getConfluenceUser() {
        return (ConfluenceUserImpl)AuthenticatedUserThreadLocal.get();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

