/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class ProductFilterUtil {
    private static ProductFilterUtil INSTANCE;
    @VisibleForTesting
    static final String CLASS_ON_BAMBOO_CLASSPATH = "com.atlassian.bamboo.build.BuildExecutionManager";
    @VisibleForTesting
    static final String CLASS_ON_BITBUCKET_CLASSPATH = "com.atlassian.bitbucket.repository.RepositoryService";
    @VisibleForTesting
    static final String CLASS_ON_CONFLUENCE_CLASSPATH = "com.atlassian.confluence.core.ContentEntityManager";
    @VisibleForTesting
    static final String CLASS_ON_FECRU_CLASSPATH = "com.atlassian.fisheye.spi.services.RepositoryService";
    @VisibleForTesting
    static final String CLASS_ON_JIRA_CLASSPATH = "com.atlassian.jira.bc.issue.IssueService";
    @VisibleForTesting
    static final String CLASS_ON_REFAPP_CLASSPATH = "com.atlassian.refapp.api.ConnectionProvider";
    @VisibleForTesting
    static final String CLASS_ON_STASH_CLASSPATH = "com.atlassian.stash.repository.RepositoryService";
    private final Log log = LogFactory.getLog(this.getClass());
    private AtomicReference<ProductFilter> filterForProduct = new AtomicReference();
    private static final Map<String, ProductFilter> PRODUCTS_TO_HOSTCLASSES;

    private ProductFilterUtil() {
    }

    public static ProductFilter getFilterForCurrentProduct(@Nullable BundleContext bundleContext) {
        return ProductFilterUtil.getInstance().getFilterForProduct(bundleContext);
    }

    public ProductFilter getFilterForProduct(@Nullable BundleContext bundleContext) {
        ProductFilter productFilter = this.filterForProduct.get();
        if (productFilter == null) {
            this.filterForProduct.compareAndSet(productFilter, this.detectProduct(bundleContext));
            productFilter = this.filterForProduct.get();
        }
        return productFilter;
    }

    private ProductFilter detectProduct(BundleContext bundleContext) {
        if (bundleContext == null) {
            this.log.warn((Object)"Couldn't detect product due to null bundleContext: will use ProductFilter.ALL");
            return ProductFilter.ALL;
        }
        for (Map.Entry<String, ProductFilter> entry : PRODUCTS_TO_HOSTCLASSES.entrySet()) {
            if (!this.detectService(bundleContext, entry.getKey())) continue;
            this.log.debug((Object)("Detected product: " + entry.getValue().name()));
            return entry.getValue();
        }
        this.log.warn((Object)"Couldn't detect product, no known services found: will use ProductFilter.ALL");
        return ProductFilter.ALL;
    }

    private boolean detectService(BundleContext bundleContext, String serviceClassName) {
        return null != bundleContext.getServiceReference(serviceClassName);
    }

    private static ProductFilterUtil getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new ProductFilterUtil();
        }
        return INSTANCE;
    }

    static {
        PRODUCTS_TO_HOSTCLASSES = ImmutableMap.builder().put(CLASS_ON_BAMBOO_CLASSPATH, ProductFilter.BAMBOO).put(CLASS_ON_BITBUCKET_CLASSPATH, ProductFilter.BITBUCKET).put(CLASS_ON_CONFLUENCE_CLASSPATH, ProductFilter.CONFLUENCE).put(CLASS_ON_FECRU_CLASSPATH, ProductFilter.FECRU).put(CLASS_ON_JIRA_CLASSPATH, ProductFilter.JIRA).put(CLASS_ON_REFAPP_CLASSPATH, ProductFilter.REFAPP).put(CLASS_ON_STASH_CLASSPATH, ProductFilter.STASH).build();
    }
}

