/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app.tracker;

import com.atlassian.migration.app.AppCloudMigrationListener;
import com.atlassian.migration.app.MigrationDetails;
import com.atlassian.migration.app.tracker.AccessScope;
import com.atlassian.migration.app.tracker.CloudMigrationListener;
import com.atlassian.migration.app.tracker.converter.MigrationDetailsConverter;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

class BoundListenerImpl
implements AppCloudMigrationListener {
    private final CloudMigrationListener listener;

    public BoundListenerImpl(CloudMigrationListener listener) {
        this.listener = listener;
    }

    public void onStartAppMigration(String transferId, MigrationDetails migrationDetails) {
        this.listener.onStartAppMigration(transferId, MigrationDetailsConverter.convert(migrationDetails));
    }

    public String getCloudAppKey() {
        return this.listener.getCloudAppKey();
    }

    public String getServerAppKey() {
        return this.listener.getServerAppKey();
    }

    public Set<com.atlassian.migration.app.AccessScope> getDataAccessScopes() {
        Set<AccessScope> dataAccessScopes = this.listener.getDataAccessScopes();
        if (dataAccessScopes == null) {
            return Collections.emptySet();
        }
        return dataAccessScopes.stream().map(it -> com.atlassian.migration.app.AccessScope.valueOf((String)it.name())).collect(Collectors.toSet());
    }
}

