/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.model.GlobalSettings;
import com.nearsoft.retrospective.model.entity.GlobalSettingsEntity;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigureService {
    private final ActiveObjects activeObjects;

    @Autowired
    public ConfigureService(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    private DatabaseType DATABASE_TYPE() {
        return this.activeObjects.moduleMetaData().getDatabaseType();
    }

    public void saveGlobalSettings(int sessionInterval, int thinkInterval, int groupInterval, int discussInterval, int summaryInterval, int summaryStopAfter) throws Exception {
        if (sessionInterval < 1 || thinkInterval < 1 || groupInterval < 1 || discussInterval < 1 || summaryInterval < 1 || summaryStopAfter < 1 || sessionInterval > 60 || thinkInterval > 60 || groupInterval > 60 || discussInterval > 60 || summaryInterval > 60 || summaryStopAfter > 60) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        GlobalSettingsEntity[] globalSettingsEntities = (GlobalSettingsEntity[])this.activeObjects.find(GlobalSettingsEntity.class);
        GlobalSettingsEntity globalSettingsEntity = globalSettingsEntities.length > 0 ? globalSettingsEntities[0] : (GlobalSettingsEntity)this.activeObjects.create(GlobalSettingsEntity.class, new DBParam[0]);
        globalSettingsEntity.setSessionInterval(sessionInterval);
        globalSettingsEntity.setThinkInterval(thinkInterval);
        globalSettingsEntity.setGroupInterval(groupInterval);
        globalSettingsEntity.setDiscussInterval(discussInterval);
        globalSettingsEntity.setSummaryInterval(summaryInterval);
        globalSettingsEntity.setSummaryStopAfter(summaryStopAfter);
        globalSettingsEntity.save();
    }

    public GlobalSettings getGlobalSettings() {
        GlobalSettingsEntity[] globalSettingsEntities = (GlobalSettingsEntity[])this.activeObjects.find(GlobalSettingsEntity.class);
        boolean saveDefault = false;
        GlobalSettingsEntity globalSettingsEntity = globalSettingsEntities.length > 0 ? globalSettingsEntities[0] : (GlobalSettingsEntity)this.activeObjects.create(GlobalSettingsEntity.class, new DBParam[0]);
        if (globalSettingsEntity.getSessionInterval() == 0) {
            globalSettingsEntity.setSessionInterval(1);
            saveDefault = true;
        }
        if (globalSettingsEntity.getThinkInterval() == 0) {
            globalSettingsEntity.setThinkInterval(10);
            saveDefault = true;
        }
        if (globalSettingsEntity.getGroupInterval() == 0) {
            globalSettingsEntity.setGroupInterval(1);
            saveDefault = true;
        }
        if (globalSettingsEntity.getDiscussInterval() == 0) {
            globalSettingsEntity.setDiscussInterval(2);
            saveDefault = true;
        }
        if (globalSettingsEntity.getSummaryInterval() == 0) {
            globalSettingsEntity.setSummaryInterval(5);
            globalSettingsEntity.setSummaryStopAfter(5);
            saveDefault = true;
        }
        if (saveDefault) {
            globalSettingsEntity.save();
        }
        GlobalSettings globalSettings = new GlobalSettings();
        globalSettings.setSessionInterval(globalSettingsEntity.getSessionInterval());
        globalSettings.setThinkInterval(globalSettingsEntity.getThinkInterval());
        globalSettings.setGroupInterval(globalSettingsEntity.getGroupInterval());
        globalSettings.setDiscussInterval(globalSettingsEntity.getDiscussInterval());
        globalSettings.setSummaryInterval(globalSettingsEntity.getSummaryInterval());
        globalSettings.setSummaryStopAfter(globalSettingsEntity.getSummaryStopAfter());
        return globalSettings;
    }
}

