/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.securityControl;

import com.nearsoft.retrospective.dto.BaseUserWithModerator;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.service.RetrospectiveUserService;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.SettingsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModeratorValidator {
    private final SessionDataService _sessionDataService;
    private final RetrospectiveUserService _retrospectiveUserService;
    private final SettingsService _settingsService;

    @Autowired
    public ModeratorValidator(SessionDataService sessionDataService, RetrospectiveUserService retrospectiveUserService, SettingsService settingsService) {
        this._sessionDataService = sessionDataService;
        this._retrospectiveUserService = retrospectiveUserService;
        this._settingsService = settingsService;
    }

    public boolean isCurrentUserPresetModeratorForRetro(long uuid) {
        RetrosSettings retrosSettings = this._settingsService.getRetrosSettingsById(uuid);
        String currentUserKey = this._retrospectiveUserService.getCurrentUserKey();
        if (currentUserKey == null || currentUserKey.isEmpty()) {
            return false;
        }
        if ("RETROS_DYNAMIC_MODERATOR".equals(retrosSettings.getPresetModeratorUserKey())) {
            return false;
        }
        return currentUserKey.equals(retrosSettings.getPresetModeratorUserKey());
    }

    public boolean isCurrentUserModeratorForRetro(long uuid) {
        User currentUser = this._retrospectiveUserService.makeRetrospectiveUser(this._retrospectiveUserService.getConfluenceUser());
        if (currentUser == null || currentUser.getUserKey() == null) {
            return false;
        }
        BaseUserWithModerator participantsWithModerator = this._sessionDataService.getSessionParticipants(uuid, null);
        if (participantsWithModerator.getModerator() == null) {
            return false;
        }
        return currentUser.getUserKey().equals(participantsWithModerator.getModerator().getUserKey());
    }
}

