(function (angular) {
  angular.module("retrospectiveApp").service("VotesService", VotesService);

  VotesService.$inject = [
    "HTTP_PATH",
    "$http",
    "SubscribableService",
    "StatefulService",
    "PollerService",
    "UtilService",
  ];

  function VotesService(
    HTTP_PATH,
    $http,
    Subscribable,
    Stateful,
    Poller,
    UtilService
  ) {
    Subscribable.make(this);

    Stateful.make(this, {
      allowNull: false,
      allowUndefined: false,
    });

    this.groupsPoller = null;

    this.stopPoller = () => {
      if (!this.groupsPoller) {
        return;
      }
      this.groupsPoller.stop();
      this.groupsPoller = null;
    };

    this.startPollers = (userKey, uuid) => {
      if (this.groupsPoller) {
        return;
      }

      this.state.set("userKey", userKey);
      this.state.set("uuid", uuid);

      this.groupsPoller = new Poller(
        `/group?uuid=${this.state.get("uuid")}`,
        (response) => {
          if (!response.data) {
            return;
          }

          //remove group with ungrouped ideas (empty)
          response.data.groupList.splice(0, 1);

          this.notify({
            identifier: "groupList",
            state: {
              groupList: response.data.groupList.map((item) => {
                item.description = UtilService.decodeHTML(item.description);
                if (!item.ideas) {
                  item.ideas = [];
                }
                item.ideas = item.ideas.map((idea) => {
                  idea.idea = UtilService.decodeHTML(idea.idea);
                  return idea;
                });
                return item;
              }),
            },
          });
        }
      );

      this.groupsPoller.start(2);
    };

    this.create = ({ uuid, data, increased }) =>
      $http.post(
        `${HTTP_PATH}/group/vote?uuid=${uuid}&increased=${increased}`,
        data
      );
  }
})(angular);
