(function (angular) {
  angular
    .module("retrospectiveApp")
    .service("SettingsService", SettingsService);

  SettingsService.$inject = [
    "HTTP_PATH",
    "$http",
    "SubscribableService",
    "UtilService",
  ];

  function SettingsService(HTTP_PATH, $http, Subscribable, UtilService) {
    Subscribable.make(this);

    this.settings = {
      anonymousPlayersAllowed: false,
      votesPerPlayer: 0,
      votesAllowedPerCard: 1,
      countTotalVotes: 0,
      columns: [
        {
          columnId: "C1",
          content: "What went well?",
          color: "#7ED321",
        },
        {
          columnId: "C2",
          content: "What didn't go well",
          color: "#D0021B",
        },
      ],
    };

    this.handlers = [];

    this.colClass = ["col-md-12 ", "col-md-6 ", "col-md-4 ", "col-md-3 "];

    this.get = (uuid) =>
      $http.get(`${HTTP_PATH}/settings/${uuid}`).then((response) => {
        this.settings = response.data;
        this.settings.columns.forEach((column) => {
          column.content = UtilService.decodeHTML(column.content);
        });
        return response.data;
      });

    this.set = (settings) => {
      this.settings = Object.assign(this.settings, settings);

      this.notify({
        identifier: "settings",
        state: {
          settings: this.settings,
        },
      });
    };

    this.getColumnClass = () => {
      return this.colClass[this.settings.columns.length - 1];
    };

    this.setTotalVotes = (totalVotes) => {
      this.settings.countTotalVotes = totalVotes;

      this.notify({
        identifier: "totalVotes",
        state: {
          totalVotes: totalVotes,
        },
      });
    };

    this.isRetroExpired = (uuid) =>
      $http
        .get(`${HTTP_PATH}/workflow/retros-expired/${uuid}`)
        .then((response) => (this.settings.isExpired = response.data));
  }
})(angular);
