/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.mappers;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.nearsoft.retrospective.mappers.UserMapper;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.entity.ActionItemEntity;
import com.nearsoft.retrospective.model.entity.GroupElementEntity;
import net.java.ao.DBParam;

public class ActionItemMapper {
    public static ActionItem map(ActionItemEntity entity) {
        ActionItem actionItem = new ActionItem();
        actionItem.setDescription(entity.getDescription());
        if (entity.getAssigneeUser() != null) {
            actionItem.setAssigneeUser(UserMapper.map(entity.getAssigneeUser()));
        }
        actionItem.setComplete(entity.getComplete());
        actionItem.setId(entity.getID());
        try {
            GroupElementEntity groupElementEntity = entity.getGroupElement();
            String columnId = groupElementEntity.getIdeas()[0].getColumnId();
            actionItem.setColumnId(columnId);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return actionItem;
    }

    public static ActionItemEntity map(ActionItem actionItem, ActiveObjects activeObjects, GroupElementEntity groupEntity, long pageId) {
        ActionItemEntity entity = (ActionItemEntity)activeObjects.create(ActionItemEntity.class, new DBParam[0]);
        entity.setComplete(actionItem.getComplete());
        if (actionItem.getAssigneeUser() != null) {
            entity.setAssigneeUser(UserMapper.maptoUserEntity(activeObjects, actionItem.getAssigneeUser()));
        }
        entity.setDescription(actionItem.getDescription());
        entity.setGroupElement(groupEntity);
        entity.setPageId("" + pageId);
        entity.setNumericPageId(pageId);
        return entity;
    }
}

