/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.macro;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.macro.ResourceAware;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.nearsoft.retrospective.macro.ColumnActionItemsPair;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.BaseUser;
import com.nearsoft.retrospective.model.RetrosColumn;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.SessionData;
import com.nearsoft.retrospective.model.entity.RetrosSettingsEntity;
import com.nearsoft.retrospective.service.GroupService;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.SettingsService;
import com.nearsoft.retrospective.version.LicenseProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class Retrospective
implements Macro,
EditorImagePlaceholder,
ResourceAware {
    private final SettingsManager settingsManager;
    private final PluginLicenseManager licenseManager;
    private final SessionDataService sessionDataService;
    private final GroupService groupService;
    private final SettingsService settingsService;
    private final Logger LOG = LoggerFactory.getLogger(Retrospective.class);
    private static final String UUID = "uuid";
    private static final String BODY_TEMPLATE = "templates/iframe.vm";
    private static final String PAGE_ID = "pageId";
    private static final String IMAGE_PATH = "download/resources/retrospectives4confluence:retrospective-resources1739132672845/images/macro-new-placeholder.png";
    private static final String LOGO_PATH = "download/resources/retrospectives4confluence:retrospective-resources1739132672845/images/logo.png";
    private static final String NOT_LICENSE_PATH = "download/resources/retrospectives4confluence:retrospective-resources1739132672845/images/macro-placeholder-renew.png";

    @Autowired
    public Retrospective(@ComponentImport SettingsManager settingsManager, @ComponentImport PluginLicenseManager licenseManager, SessionDataService sessionDataService, GroupService groupService, SettingsService settingsService) {
        this.settingsManager = settingsManager;
        this.licenseManager = licenseManager;
        this.sessionDataService = sessionDataService;
        this.groupService = groupService;
        this.settingsService = settingsService;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> params, ConversionContext ctx) {
        ImageDimensions dimensions = new ImageDimensions(590, 197);
        String imagePath = this.settingsManager.getGlobalSettings().getBaseUrl() + "/" + (this.isLicenseValid() ? IMAGE_PATH : NOT_LICENSE_PATH);
        return new DefaultImagePlaceholder(imagePath, false, dimensions);
    }

    public String execute(Map<String, String> parameters, String s2, ConversionContext conversionContext) throws MacroExecutionException {
        String pageId = conversionContext.getEntity().getIdAsString();
        String uuid = parameters.getOrDefault("agile-retrospectives-for-confluence-uuid", pageId);
        this.LOG.info("[agile-retrospectives-for-confluence] - PageId: {} UUID: {}", (Object)pageId, (Object)uuid);
        long retroId = uuid.isEmpty() ? conversionContext.getEntity().getId() : Long.parseLong(uuid);
        RetrosSettings retrosSettings = this.settingsService.getRetrosSettingsById(retroId);
        retroId = this.getRetroIdFromPage(retroId, retrosSettings, Long.parseLong(pageId), conversionContext.getSpaceKey());
        if (retroId == -1L) {
            this.LOG.error("[agile-retrospectives-for-confluence] - Error getting retroId from page ", (Object)pageId);
            throw new MacroExecutionException("Cannot get retroId");
        }
        switch (conversionContext.getOutputType()) {
            case "html_export": 
            case "pdf": 
            case "word": {
                ActionItem[] actionItems = this.groupService.getActionItemsForRetro(retroId);
                SessionData sessionData = this.sessionDataService.getSessionDataByUUID(retroId);
                return this.generatePDF(actionItems, sessionData, retrosSettings, parameters, conversionContext);
            }
        }
        SessionData sessionData = this.sessionDataService.getSessionDataByUUID(retroId);
        if (sessionData == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - Error retrieving and creating new session data with pageId {} and uuid {}", (Object)pageId, (Object)retroId);
            throw new MacroExecutionException("The retrospective session can't be found");
        }
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put(PAGE_ID, pageId);
        contextMap.put(UUID, retroId);
        return VelocityUtils.getRenderedTemplate((String)BODY_TEMPLATE, (Map)contextMap);
    }

    public long getRetroIdFromPage(long retroId, RetrosSettings retrosSettings, long pageId, String spaceKey) {
        if (retrosSettings.isTemplate()) {
            RetrosSettingsEntity retro;
            Long retroTemplateId = this.settingsService.searchRetroTemplate(pageId, retroId);
            if (retroTemplateId != null) {
                return retroTemplateId;
            }
            try {
                retro = this.settingsService.createAndSaveRetrosSettings(retrosSettings.getVotesPerPlayer(), retrosSettings.getVotesAllowedPerCard(), retrosSettings.isAnonymousPlayersAllowed(), retrosSettings.getPresetModeratorUserKey(), false, retrosSettings.getFormatId(), spaceKey);
            }
            catch (Exception e) {
                this.LOG.error("[agile-retrospectives-for-confluence] - error get retro from createAndSaveRetrosSettings", (Throwable)e);
                return -1L;
            }
            RetrosColumn[] columns = retrosSettings.getColumns();
            this.setColumnsContentToRetroTemplate(retro, columns);
            this.settingsService.saveRetroTemplate(pageId, retro.getID(), retroId);
            return retro.getID();
        }
        return retroId;
    }

    public void setColumnsContentToRetroTemplate(RetrosSettingsEntity retro, RetrosColumn[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            String content = columns[i].getContent();
            String color = columns[i].getColor();
            String columnId = "C" + (i + 1);
            this.settingsService.saveAndCreateRetrosColumn(retro, content, color, columnId);
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String getResourcePath() {
        return this.isLicenseValid() ? IMAGE_PATH : NOT_LICENSE_PATH;
    }

    public void setResourcePath(String s2) {
    }

    private boolean isLicenseValid() {
        if (LicenseProperties.enabled) {
            return this.licenseManager.getLicense().isDefined() && !((PluginLicense)this.licenseManager.getLicense().get()).getError().isDefined();
        }
        return true;
    }

    private String generatePDF(ActionItem[] actionItems, SessionData sessionData, RetrosSettings retrosSettings, Map<String, String> parameters, ConversionContext conversionContext) {
        if (sessionData == null) {
            return "<img src=\"" + this.getImagePlaceholder(parameters, conversionContext).getUrl() + "\"/>";
        }
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("logoUrl", this.settingsManager.getGlobalSettings().getBaseUrl() + "/download/resources/retrospectives4confluence:retrospective-resources1739132672845/images/logo.png");
        contextMap.put("baseUrl", this.settingsManager.getGlobalSettings().getBaseUrl());
        contextMap.put("retrosSettings", retrosSettings);
        contextMap.put("sessionData", sessionData);
        int rows = (int)Math.ceil(sessionData.getBaseUsers().length / 3);
        BaseUser[][] baseUser = new BaseUser[rows + 1][3];
        BaseUser[] users = sessionData.getBaseUsers();
        int i = 0;
        for (int j = 0; j < baseUser.length; ++j) {
            for (int k = 0; k < baseUser[j].length; ++k) {
                if (i >= users.length) continue;
                baseUser[j][k] = users[i];
                ++i;
            }
        }
        ArrayList<ColumnActionItemsPair> columnActionItemsPairs = new ArrayList<ColumnActionItemsPair>();
        for (int j = 0; j < retrosSettings.getColumns().length; ++j) {
            ColumnActionItemsPair columnActionItemsPair = new ColumnActionItemsPair();
            columnActionItemsPair.setColumn(retrosSettings.getColumns()[j]);
            for (int k = 0; k < actionItems.length; ++k) {
                if (!actionItems[k].getColumnId().equals(retrosSettings.getColumns()[j].getColumnId())) continue;
                columnActionItemsPair.addActionItem(actionItems[k]);
            }
            if (columnActionItemsPair.getActionItems().isEmpty()) continue;
            columnActionItemsPairs.add(columnActionItemsPair);
        }
        contextMap.put("emptyActionItems", actionItems.length == 0);
        contextMap.put("actionItems", columnActionItemsPairs);
        contextMap.put("chunkUsers", baseUser);
        return VelocityUtils.getRenderedTemplate((String)"templates/pdf-report.vm", contextMap);
    }
}

