(function (angular) {
  angular
    .module("retrospectiveApp")
    .controller("groupController", GroupController);

  GroupController.$inject = [
    "IMAGES_BASE_PATH",
    "HTTP_PATH",
    "$http",
    "$scope",
    "IdeasService",
    "SettingsService",
    "UtilService",
    "GroupsService",
    "StatefulService",
    "WorkflowService",
  ];

  function GroupController(
    IMAGES_BASE_PATH,
    HTTP_PATH,
    $http,
    $scope,
    IdeasService,
    SettingsService,
    UtilService,
    GroupsService,
    Stateful,
    WorkflowService
  ) {
    Stateful.make(this);

    const vm = this;

    this.readOnlyMode = false;
    this.IMAGES_BASE_PATH = IMAGES_BASE_PATH;
    vm.userKey = $scope.$parent.vm.userKey;
    vm.uuid = $scope.$parent.vm.uuid;
    vm.moderator = $scope.$parent.vm.moderator;
    this.settings = SettingsService.settings;
    this.groupedIdeas = {};
    this.groupedIdeas.list = [];
    this.groupedIdeas.name = "";
    this.lastGroupNameValue = "";
    this.showGroupName = true;
    this.showRepeatedGroupNameError = false;
    this.colorsColumn = SettingsService.settings.columnColors;

    vm.thinkElements = [];
    this.addedIdeas = [];
    this.removedIdeas = [];

    function onlyUnique(value, index, self) {
      return self.indexOf(value) === index;
    }

    $http
      .get(`${HTTP_PATH}/ideas?uuid=${vm.uuid}`)
      .then((response) => {
        vm.thinkElements = response.data.map((idea) => {
          idea.idea = UtilService.decodeHTML(idea.idea);
          return idea;
        });
      })
      .catch((err) => {
        console.error(err);
        const flagError = AJS.flag({
          type: "error",
          body: 'An error has occurred. Please try again and <a href="https://planningpoker.atlassian.net/servicedesk/customer/portal/2/group/2/create/8" target="_blank">contact support</a> if the issue persists.',
        });
      });

    WorkflowService.subscribe(
      (event) => {
        this.readOnlyMode = true;
      },
      ["readOnlyMode"]
    );

    SettingsService.subscribe(
      (event) => {
        this.settings = event.state.settings;
      },
      ["settings"]
    );

    GroupsService.subscribe(
      (event) => {
        if (this.thinkElements && this.thinkElements.length) {
          if (this.removedIdeas.length) {
            this.removedIdeas.forEach((idea) => {
              event.state.groupedIdea.ids = event.state.groupedIdea.ids.filter(
                (id) => id !== idea.id
              );
            });

            this.removedIdeas = [];
          }

          const lengthBefore = event.state.groupedIdea.ids.length;
          if (event.state.groupedIdea.ids.length && this.addedIdeas) {
            this.addedIdeas
              .map((i) => `${i.id}`)
              .forEach((id) => {
                if (event.state.groupedIdea.ids.indexOf(id) == -1) {
                  event.state.groupedIdea.ids.push(id);
                }
              });
          }

          this.groupedIdeas.name = event.state.groupedIdea.name;
          this.groupedIdeas.list = event.state.groupedIdea.ids
            .filter((id) => id)
            .map((id) => vm.thinkElements.find((i) => i.id == id));

          // if we are sync, delete locally applied ideas
          if (lengthBefore == this.groupedIdeas.list.length) {
            this.addedIdeas = [];
          }

          if (!event.state.groupedIdea.ids.length) {
            this.addedIdeas = [];
            this.removedIdeas = [];
          }
        }
      },
      ["groupedIdea"]
    );

    // Method to check if a given group id has actually just an idea

    this.isGroup = (group) => {
      if (group.ideas.length === 1 && !group.description) {
        group.grouped = false;
        return false;
      }
      return true;
    };

    GroupsService.subscribe(
      (event) => {
        if (this.addedIdeas.length) {
          this.addedIdeas.forEach((idea) => {
            event.state.groupList[0].ideas =
              event.state.groupList[0].ideas.filter((i) => i.id != idea.id);
          });
        }

        const lengthBefore = event.state.groupList[0].ideas.length;
        if (this.removedIdeas.length) {
          this.removedIdeas.forEach((idea) => {
            event.state.groupList[0].ideas.push(idea);
          });
        }

        this.groupCollection = {
          groupList: event.state.groupList.map((group) => {
            group.ideas = group.ideas.filter(onlyUnique);
            return group;
          }),
        };

        this.groupCollection.groupList.forEach((group) => {
          if (group.grouped) {
            this.isGroup(group);
          }
        });

        // if we are sync, delete locally applied ideas
        if (lengthBefore === this.groupCollection.groupList[0].ideas.length) {
          this.removedIdeas = [];
        }
      },
      ["groupList"]
    );

    this.compareFirstIdea = (group) => {
      if (
        this.isGroupOpen() &&
        group.ideas.length === 1 &&
        this.groupedIdeas.list.length === 1
      ) {
        return group.ideas[0].id === this.groupedIdeas.list[0].id;
      }
      return false;
    };

    WorkflowService.subscribe(
      (event) => {
        this.moderator = event.state.moderator;
      },
      ["moderator"]
    );

    /*
         apply drag and drop changes locally to avoid
         cards blinking between updates from "server stream"
         */
    this.addToAvailableIdeas = (idea) => {
      this.groupCollection.groupList[0].ideas.push(idea);
      const index = this.groupedIdeas.list.indexOf(idea);
      this.groupedIdeas.list.splice(index, 1);

      this.removedIdeas.push(idea);
    };

    this.addToGroupedIdea = (idea) => {
      const index = this.groupCollection.groupList[0].ideas.indexOf(idea);
      this.groupCollection.groupList[0].ideas.splice(index, 1);
      this.groupedIdeas.list.push(idea);

      this.addedIdeas.push(idea);
    };

    this.applyToGroupedIdea = () => {};

    this.applyToAvailableIdeas = () => {};

    /*
         other functions
         */
    this.showPlusButton = () => !this.isEmptyGroup();

    this.getTotalIssues = () => {
      if (!this.groupCollection || !this.groupCollection.groupList) {
        return 0;
      }

      let counter = 0;

      this.groupCollection.groupList.forEach((groupElement) => {
        if (groupElement.grouped) {
          counter++;
        } else {
          counter += groupElement.ideas.length;
        }
      });

      return counter;
    };

    this.isCurrentUserMod = () =>
      this.moderator && this.moderator.userKey === this.userKey;

    this.isGroupOpen = () => this.groupedIdeas.list.length;

    this.isEmptyGroup = () => {
      if (!this.groupedIdeas || !this.groupedIdeas.list.length) {
        this.groupedIdeas.name = "";
        return true;
      }
      return false;
    };

    this.dropGroupListAdd = (idea) => {
      if (!this.groupedIdeas.list.length) {
        this.createGroupWithButton(idea);
      } else {
        this.addIdeaToGroup(idea);
      }

      this.startDragginRight = false;
      this.startDragginLeft = false;
    };

    this.dropGroupListRemove = (idea) => {
      this.removeIdeaFromGroup(idea);
      this.startDragginRight = false;
      this.startDragginLeft = false;
    };

    this.dndAvailable = () => {
      return true;
      if (this.isCurrentUserMod()) {
        return true;
      }
      return !!this.groupedIdeas.list.length;
    };

    this.insertGroupName = () => {
      if (vm.groupName === vm.lastGroupNameValue) {
        vm.showGroupName = true;
        vm.showRepeatedGroupNameError = false;
        return;
      }

      if (!vm.groupName) {
        vm.groupName = "Untitled group";
      }

      GroupsService.editGroupName(vm.groupName)
        .then(() => {
          vm.showGroupName = true;
          vm.showRepeatedGroupNameError = false;
        })
        .catch(() => {
          vm.showRepeatedGroupNameError = true;
        });
    };

    this.createGroupWithButton = (idea) => {
      GroupsService.createGroupedIdea(idea).catch((err) => {
        console.error(err);
        const flagError = AJS.flag({
          type: "error",
          body: 'An error has occurred. Please try again and <a href="https://planningpoker.atlassian.net/servicedesk/customer/portal/2/group/2/create/8" target="_blank">contact support</a> if the issue persists.',
        });
      });
    };

    this.addIdeaToGroup = (idea) => {
      GroupsService.addIdeaToGroupedIdea(idea).catch((err) => {
        console.error(err);
        const flagError = AJS.flag({
          type: "error",
          body: 'An error has occurred. Please try again and <a href="https://planningpoker.atlassian.net/servicedesk/customer/portal/2/group/2/create/8" target="_blank">contact support</a> if the issue persists.',
        });
      });
    };

    // cuando se da click en el boton de menos, para quitar una idea y mandarla hacia la izquierda
    this.removeIdeaFromGroup = (idea) => {
      this.addToAvailableIdeas(idea);
      GroupsService.removeIdeaFromGroupedIdea(idea).catch((err) => {
        console.error(err);
        const flagError = AJS.flag({
          type: "error",
          body: 'An error has occurred. Please try again and <a href="https://planningpoker.atlassian.net/servicedesk/customer/portal/2/group/2/create/8" target="_blank">contact support</a> if the issue persists.',
        });
      });
    };

    this.persistGroup = () => {
      this.removedIdeas = [];
      this.addedIdeas = [];
      GroupsService.saveGroup().catch((err) => {
        console.error(err);
        const flagError = AJS.flag({
          type: "error",
          body: 'An error has occurred. Please try again and <a href="https://planningpoker.atlassian.net/servicedesk/customer/portal/2/group/2/create/8" target="_blank">contact support</a> if the issue persists.',
        });
      });
    };

    this.deleteGroup = () => {
      this.removedIdeas = [];
      this.addedIdeas = [];
      GroupsService.breakGroup().catch((err) => {
        console.error(err);
        const flagError = AJS.flag({
          type: "error",
          body: 'An error has occurred. Please try again and <a href="https://planningpoker.atlassian.net/servicedesk/customer/portal/2/group/2/create/8" target="_blank">contact support</a> if the issue persists.',
        });
      });
    };

    // cuando se da click en un grupo para modificar sus tareas
    this.openGroup = (group) =>
      GroupsService.editGroup(group).catch((err) => {
        console.error(err);
        const flagError = AJS.flag({
          type: "error",
          body: 'An error has occurred. Please try again and <a href="https://planningpoker.atlassian.net/servicedesk/customer/portal/2/group/2/create/8" target="_blank">contact support</a> if the issue persists.',
        });
      });

    this.editGroupName = () => {
      this.showGroupName = false;
      vm.groupName = vm.groupedIdeas.name;

      setTimeout(() => {
        $(`#group-name-input${vm.uuid}`).focus();
        if (vm.groupName == "Untitled group") {
          vm.groupName = "";
        }
      }, 300);
    };

    this.shouldShowNewGroupIcon = (group) =>
      !group.grouped && !this.groupedIdeas.list.length;

    this.saveLastValue = () =>
      (this.lastGroupNameValue = this.groupedIdeas.name);

    this.undoGroupName = () =>
      (this.groupedIdeas.name = this.lastGroupNameValue);

    this.createGroupWithButtonAndFocus = (idea) => {
      if (!this.groupedIdeas.name) {
        this.showGroupName = false;
      }

      $.when(this.createGroupWithButton(idea)).then(() => {
        if (!this.groupedIdeas.name) {
          $("#group-name-input").focus();
        }
      });
    };

    this.groupDragStartRight = () => (this.startDragginRight = true);

    this.groupDragStartLeft = () => (this.startDragginLeft = true);

    this.getGroupItemClasses = (idea, group) => {
      if (group.isCollapsed == undefined) {
        group.isCollapsed = true;
      }
      let classes = "retro-list-item vote-group-transition ";
      classes += group.grouped && group.isCollapsed ? " ideas-grouped " : "";
      classes +=
        group.grouped && group.isCollapsed && group.ideas.length > 1
          ? " collapsed-ideas"
          : "";
      return classes;
    };

    this.collapseGroup = (group) => {
      if (group.grouped) {
        group.isCollapsed = !group.isCollapsed;
      }
    };

    this.dragIdeasEnabled = () => this.isCurrentUserMod() || this.isGroupOpen();

    this.getDndTypeNewGroup = () => `grouping${this.uuid}`;
    this.getDndTypeGroups = () => `groups${this.uuid}`;
    $scope.$on("$destroy", this.persistGroup);
  }
})(angular);
