(function (angular) {
    angular
        .module('retrospectiveApp')
        .service('IdeasService', IdeasService);

    IdeasService.$inject = ['HTTP_PATH', '$http', 'SubscribableService', 'StatefulService', 'PollerService'];

    function IdeasService(HTTP_PATH, $http, Subscribable, Stateful, Poller) {
        Subscribable.make(this);
        Stateful.make(this, {
            allowNull: false,
            allowUndefined: false
        });

        this.ideasPoller = null;

        this.stopPoller = () => {
            if (!this.ideasPoller) {
                return;
            }

            this.ideasPoller.stop();
            this.ideasPoller = null;
        };

        this.startPollers = (userKey, uuid, interval) => {
            if (this.ideasPoller) {
                return;
            }

            this.state.set('ideasMap', {});
            this.state.set('userKey', userKey);
            this.state.set('uuid', uuid);

            const countIdeas = (map) => Object.keys(map).reduce((a, c) => a + map[c].length, 0);

            /*
             Will take care of:

             - ideas in think stage
             */
            this.ideasPoller = new Poller(`/ideas?uuid=${uuid}`, (response) => {
                const ideas = response.data || [];
                const ideasMap = {};

                ideas.forEach((idea) => {
                    ideasMap[idea.columnId] = ideasMap[idea.columnId] || [];
                    ideasMap[idea.columnId].push(idea);
                });

                const existent = countIdeas(this.state.get('ideasMap', {}));
                const fromResponse = ideas.length;

                if (existent !== fromResponse) {
                    this.state.set('ideasMap', ideasMap);

                    this.notify({
                        identifier: 'ideas',
                        state: {
                            ideas: ideasMap
                        }
                    });
                }
            }, interval);

            this.ideasPoller.start();
        };

        this.setIdeasMapToState = async (uuid) => {
            try {
                const response = await $http.get(`${HTTP_PATH}/ideas?uuid=${uuid}`)
                const ideas = response.data || [];
                const ideasMap = {};

                ideas.forEach((idea) => {
                    ideasMap[idea.columnId] = ideasMap[idea.columnId] || [];
                    ideasMap[idea.columnId].push(idea);
                });
                this.state.set('ideasMap', ideasMap);
            } catch (err) {
                console.error(err);
            }
        }

        this.getIdeasListByColumnId = (columnId) =>
            this.state.get('ideasMap', {})[columnId];

        this.create = ({idea, columnId}) =>
            $http.post(`${HTTP_PATH}/ideas?uuid=${this.state.get('uuid')}`, {idea, columnId})
            .then(() => {
                this.ideasPoller.poll();
            });

        this.remove = (ideaId) => {
            const uuid = this.state.get('uuid');
            return $http.delete(`${HTTP_PATH}/ideas?uuid=${uuid}&id=${ideaId}`).then(() => {
                this.ideasPoller.poll();
            })
        };

        this.update = (idea) => {
            const uuid = this.state.get('uuid');

            return $http.put(`${HTTP_PATH}/ideas/${idea.id}?&uuid=${uuid}`, {idea:idea.idea});
        };
    }
}(angular));
