/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.securityControl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.permissions.OperationCheckResult;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.Target;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.permissions.OperationService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.exception.PermissionRevokedException;
import com.nearsoft.retrospective.model.entity.RetrosSettingsEntity;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionValidator {
    @ConfluenceImport
    private final ContentService contentService;
    @ConfluenceImport
    private final SpaceService spaceService;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ConfluenceImport
    private final PermissionManager permissionManager;
    @ConfluenceImport
    private final OperationService operationService;
    private final Logger LOG = LoggerFactory.getLogger(PermissionValidator.class);

    @Autowired
    public PermissionValidator(ContentService contentService, SpaceService spaceService, ActiveObjects activeObjects, PermissionManager permissionManager, OperationService operationService) {
        this.contentService = contentService;
        this.spaceService = spaceService;
        this.activeObjects = activeObjects;
        this.permissionManager = permissionManager;
        this.operationService = operationService;
    }

    public void validatePagePermission(long pageId) throws FourHundredException {
        Content page = (Content)this.contentService.find(new Expansion[0]).withType(new ContentType[]{ContentType.PAGE}).withId(ContentId.of((long)pageId), new ContentId[0]).fetchOrNull();
        if (page == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - no page - pageId: {}", (Object)pageId);
            throw new PermissionRevokedException();
        }
    }

    public void validateSpacePermission(String spaceKey) throws FourHundredException {
        Space space = (Space)this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetchOrNull();
        if (space == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - no space - spaceKey: {}", (Object)spaceKey);
            throw new PermissionRevokedException();
        }
    }

    public void validatePagePermissionByRetroId(int retroId) throws FourHundredException {
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.get(RetrosSettingsEntity.class, (Object)retroId);
        if (retrosSettingsEntity == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - no entity - retroId: {}", (Object)retroId);
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        Long pageId = retrosSettingsEntity.getPageId();
        if (pageId == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - no page - retroId: {}", (Object)retroId);
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        this.validatePagePermission(pageId);
    }

    public void validatePagePermissionsIfExistsByRetroId(int retroId) throws FourHundredException {
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.get(RetrosSettingsEntity.class, (Object)retroId);
        if (retrosSettingsEntity == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - no entity - retroId: {}", (Object)retroId);
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        Long pageId = retrosSettingsEntity.getPageId();
        if (pageId != null) {
            this.validatePagePermission(pageId);
        }
    }

    public void validatePageEditPermissionByRetroId(int retroId, Long pageId) throws FourHundredException {
        this.validateEditPagePermission(pageId);
        RetrosSettingsEntity retrosSettingsEntity = (RetrosSettingsEntity)this.activeObjects.get(RetrosSettingsEntity.class, (Object)retroId);
        if (retrosSettingsEntity == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - no entity - retroId: {} pageId: {}", (Object)retroId, (Object)pageId);
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
        Long savedPageId = retrosSettingsEntity.getPageId();
        if (savedPageId != null && !savedPageId.equals(pageId)) {
            this.LOG.error("[agile-retrospectives-for-confluence] - pageId doesn't match - retroId: {} pageId: {}", (Object)retroId, (Object)pageId);
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
    }

    public void validateEditPagePermission(long pageId) throws FourHundredException {
        Content page = (Content)this.contentService.find(new Expansion[]{new Expansion("space")}).withType(new ContentType[]{ContentType.PAGE}).withId(ContentId.of((long)pageId), new ContentId[0]).fetchOrNull();
        if (page == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - no page - pageId: {}", (Object)pageId);
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
        boolean hasPermission = false;
        try {
            Method hasPermissionMethod = this.permissionManager.getClass().getMethod("hasPermission", ConfluenceUser.class, Permission.class, Object.class);
            hasPermission = (Boolean)hasPermissionMethod.invoke((Object)this.permissionManager, AuthenticatedUserThreadLocal.get(), Permission.EDIT, page);
        }
        catch (NoSuchMethodException e) {
            try {
                Method hasPermissionMethod = this.permissionManager.getClass().getMethod("hasPermission", User.class, Permission.class, Object.class);
                hasPermission = (Boolean)hasPermissionMethod.invoke((Object)this.permissionManager, AuthenticatedUserThreadLocal.get(), Permission.EDIT, page);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!hasPermission) {
            this.LOG.error("[agile-retrospectives-for-confluence] - user has no edit permissions - pageId: {}", (Object)pageId);
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
        Optional<OperationCheckResult> updateOperation = this.operationService.getAvailableOperations(Target.forModelObject((Object)page)).stream().filter(operationCheckResult -> operationCheckResult.getOperationKey().equals((Object)OperationKey.UPDATE)).findFirst();
        if (!updateOperation.isPresent()) {
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
    }

    public void isConfluenceAdmin() throws FourHundredException {
        ConfluenceUser cUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(cUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            throw new FourHundredException(Response.Status.FORBIDDEN);
        }
    }
}

