/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.migration_to_cloud.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.DeletedUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.tracker.CloudMigrationAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.google.gson.Gson;
import com.nearsoft.retrospective.dto.BaseUserWithModerator;
import com.nearsoft.retrospective.mappers.SessionDataMapper;
import com.nearsoft.retrospective.mappers.ThinkElementMapper;
import com.nearsoft.retrospective.migration_to_cloud.dto.AccessRestrictionDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.ActionItemDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.ColumnDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.IssueDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.MigrationsDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.NoteDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.PlayerDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.PlayerVoteDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.RetrospectiveDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.ServerMigrationDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.SettingsDTO;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.BaseUser;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.SessionData;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.VoteElement;
import com.nearsoft.retrospective.model.entity.ActionItemEntity;
import com.nearsoft.retrospective.model.entity.FormatEntity;
import com.nearsoft.retrospective.model.entity.SessionDataEntity;
import com.nearsoft.retrospective.model.entity.SessionUserEntity;
import com.nearsoft.retrospective.model.entity.ThinkElementEntity;
import com.nearsoft.retrospective.service.GroupService;
import com.nearsoft.retrospective.service.QueryHelper;
import com.nearsoft.retrospective.service.SettingsService;
import com.nearsoft.retrospective.util.DateUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetrosMapDataService {
    private SettingsService settingsService;
    private GroupService groupService;
    private ActiveObjects activeObjects;
    private UserAccessor userAccessor;
    private static final Map<String, String> RETROS_LOCATION = new HashMap<String, String>();
    private static final String WAIT_LOCATION = "wait";
    private static final String THINK_LOCATION = "think";
    private static final String GROUP_LOCATION = "group";
    private static final String VOTE_LOCATION = "vote";
    private static final String DISCUSS_LOCATION = "discuss";
    private static final String RESULTS_CLOUD_LOCATION = "results";
    private static final String CONFLUENCE_USER_KEY_PREFIX = "confluence.userkey/";
    private static final String RESULT_VIEW = "result";
    private static final String ARCHIVED_VIEW = "archived";

    @Autowired
    public RetrosMapDataService(SettingsService settingsService, GroupService groupService, @ComponentImport ActiveObjects activeObjects, @ComponentImport UserAccessor userAccessor) {
        this.settingsService = settingsService;
        this.groupService = groupService;
        this.activeObjects = activeObjects;
        this.userAccessor = userAccessor;
    }

    public List<RetrospectiveDTO> matchRetrosForCloud(String transferId, CloudMigrationAccessor accessor, String clientKey) {
        Gson gson = new Gson();
        FormatEntity[] formatsArray = (FormatEntity[])this.activeObjects.executeInTransaction(() -> (FormatEntity[])this.activeObjects.find(FormatEntity.class));
        HashMap formats = new HashMap();
        Arrays.stream(formatsArray).forEach(format -> formats.put(format.getID(), format.getName()));
        List<RetrosSettings> retrosInServer = this.settingsService.getAllRetros();
        ArrayList<RetrospectiveDTO> retrosForCloud = new ArrayList<RetrospectiveDTO>();
        for (RetrosSettings retro : retrosInServer) {
            ArrayList<ThinkElement> groupIdeas;
            Object groupElement22;
            int retroId = retro.getId();
            String presetModeratorKey = retro.getPresetModeratorUserKey();
            String creatorUserKey = retro.getCreatorUserKey().orElse(null);
            boolean useStaticModerator = presetModeratorKey != null && !presetModeratorKey.equals("RETROS_DYNAMIC_MODERATOR");
            Set<String> retroUserKeys = new HashSet<String>();
            retroUserKeys.add(CONFLUENCE_USER_KEY_PREFIX + creatorUserKey);
            if (useStaticModerator) {
                retroUserKeys.add(CONFLUENCE_USER_KEY_PREFIX + presetModeratorKey);
            }
            Map<String, String> retroUserKeyMappings = accessor.getCloudMigrationGateway().getMappingById(transferId, "identity:user", retroUserKeys);
            RetrospectiveDTO retroForCloud = new RetrospectiveDTO();
            retroForCloud.setDeleted(Boolean.FALSE);
            retroForCloud.setArchived(Boolean.FALSE);
            retroForCloud.setTemplate(Boolean.TRUE);
            retroForCloud.setTemplateUses(0);
            retroForCloud.setRoomId(null);
            retroForCloud.setClientKey(clientKey);
            retroForCloud.setInstanceId(null);
            retroForCloud.setCreatedBy(retroUserKeyMappings.get(CONFLUENCE_USER_KEY_PREFIX + creatorUserKey));
            retroForCloud.setFormat(null);
            retroForCloud.setAccessRestrictions(new ArrayList<AccessRestrictionDTO>());
            retroForCloud.setFormatName((String)formats.get(retro.getFormatId()));
            SessionData retroSessionData = (SessionData)this.activeObjects.executeInTransaction(() -> {
                SessionDataEntity[] sessionDataEntities = (SessionDataEntity[])this.activeObjects.find(SessionDataEntity.class, QueryHelper.ByPageId(retroId));
                SessionData sessionData = sessionDataEntities.length > 0 ? SessionDataMapper.map(sessionDataEntities[0]) : this.createDefaultSessionData(retroId);
                String view = sessionData.getViewName();
                Query participantsQuery = QueryHelper.ByPageIdAndLastSeen(retroId);
                if (ARCHIVED_VIEW.equals(view) || RESULT_VIEW.equals(view)) {
                    participantsQuery = QueryHelper.ByPageId(retroId);
                }
                SessionUserEntity[] sessionUserEntities = (SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, participantsQuery);
                ArrayList<BaseUser> baseUsers = new ArrayList<BaseUser>();
                for (int i = 0; i < sessionUserEntities.length; ++i) {
                    SessionUserEntity sessionUserEntity = sessionUserEntities[i];
                    BaseUser baseUser = new BaseUser();
                    baseUser.setId(sessionUserEntity.getID());
                    baseUser.setFullName(sessionUserEntity.getFullName());
                    baseUser.setImageUri(sessionUserEntity.getImageUri());
                    baseUser.setName(sessionUserEntity.getName());
                    baseUser.setPageId(sessionUserEntity.getPageId());
                    baseUser.setNumericPageId(sessionUserEntity.getNumericPageId());
                    baseUser.setUserKey(sessionUserEntity.getUserKey());
                    baseUser.setConnected(sessionUserEntity.getIsConnected());
                    baseUser.setModerator(false);
                    baseUser.setReady(sessionUserEntity.getIsReady());
                    baseUser.setParticipant(sessionUserEntity.getIsParticipant());
                    baseUsers.add(baseUser);
                }
                BaseUserWithModerator participantsWithModerator = new BaseUserWithModerator(baseUsers.toArray(new BaseUser[baseUsers.size()]), null, presetModeratorKey);
                sessionData.setParticipants(participantsWithModerator.getParticipants());
                sessionData.setPresetModeratorUserKey(participantsWithModerator.getPresetModeratorUserKey());
                return sessionData;
            });
            String retroView = retroSessionData.getViewName();
            retroForCloud.setFinished(RETROS_LOCATION.get(retroView).equals(RESULTS_CLOUD_LOCATION));
            retroForCloud.setLocation(RETROS_LOCATION.get(retroView));
            retroForCloud.setStarted(!RETROS_LOCATION.get(retroView).equals(WAIT_LOCATION));
            retroForCloud.setServerMigration(new ServerMigrationDTO(retroId));
            if (retroForCloud.isFinished()) {
                String completionDate = retroSessionData.getCompletionDate();
                String finishDate = LocalDateTime.now().atZone(ZoneId.systemDefault()).toString();
                try {
                    if (completionDate != null && !completionDate.isEmpty()) {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
                        LocalDateTime dateTime = LocalDateTime.parse(completionDate, formatter);
                        finishDate = dateTime.atZone(ZoneId.systemDefault()).toString().split("\\[")[0];
                    }
                    retroForCloud.setFinishDate(finishDate);
                }
                catch (Exception e) {
                    retroForCloud.setFinishDate(LocalDateTime.now().atZone(ZoneId.systemDefault()).toString().split("\\[")[0]);
                }
            }
            SettingsDTO settingsDTO = new SettingsDTO();
            settingsDTO.setGuid(null);
            settingsDTO.setVotesPerPlayer(retro.getVotesPerPlayer());
            settingsDTO.setUnlimitedVotesPerPlayer(retro.getVotesPerPlayer() == 0);
            settingsDTO.setVotesPerCard(retro.getVotesAllowedPerCard());
            settingsDTO.setUnlimitedVotesPerCard(retro.getVotesAllowedPerCard() == 0);
            settingsDTO.setAnonymous(retro.isAnonymousPlayersAllowed());
            if (useStaticModerator) {
                ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(presetModeratorKey));
                if (user != null && !DeletedUser.isDeletedUser((User)user) && !this.userAccessor.isDeactivated(user.getName())) {
                    settingsDTO.setModeratorAccountId(retroUserKeyMappings.get(CONFLUENCE_USER_KEY_PREFIX + presetModeratorKey));
                } else {
                    useStaticModerator = false;
                    settingsDTO.setModeratorAccountId(null);
                }
            } else {
                settingsDTO.setModeratorAccountId(null);
            }
            settingsDTO.setUseStaticModerator(useStaticModerator);
            retroForCloud.setSettings(settingsDTO);
            MigrationsDTO migrationsDTO = new MigrationsDTO(Boolean.TRUE);
            retroForCloud.setMigrations(migrationsDTO);
            ArrayList<ColumnDTO> columns = new ArrayList<ColumnDTO>();
            Arrays.stream(retro.getColumns()).forEach(column -> columns.add(new ColumnDTO(column.getColumnId(), column.getContent(), column.getColor())));
            retroForCloud.setColumns(columns);
            List<GroupElement> retroGroups = this.groupService.getGroupsByPageId(retroId, this.getThinkElementsList(retroId)).getGroupList();
            retroGroups = retroGroups.stream().filter(retroGroup -> retroGroup.getIdeas() != null).collect(Collectors.toList());
            List groupOfIdeasNonGrouped = retroGroups.stream().filter(groupElement -> groupElement.isGrouped() == false && groupElement.getIdeas().size() > 1).collect(Collectors.toList());
            for (Object groupElement22 : groupOfIdeasNonGrouped) {
                for (ThinkElement ideaElement : ((GroupElement)groupElement22).getIdeas()) {
                    groupIdeas = new ArrayList<ThinkElement>();
                    groupIdeas.add(ideaElement);
                    retroGroups.add(new GroupElement(null, groupIdeas));
                }
            }
            retroGroups.removeAll(groupOfIdeasNonGrouped);
            ArrayList<IssueDTO> issueDTOS = new ArrayList<IssueDTO>();
            groupElement22 = retroGroups.iterator();
            while (groupElement22.hasNext()) {
                GroupElement groupElement3 = (GroupElement)groupElement22.next();
                IssueDTO issueDTO = new IssueDTO();
                groupIdeas = groupElement3.getIdeas();
                String groupDescription = groupElement3.getDescription();
                if (groupIdeas.size() == 1) {
                    issueDTO.setTitle(((ThinkElement)groupIdeas.get(0)).getIdea());
                    issueDTO.setType(null);
                } else {
                    if (groupDescription == null || groupDescription.isEmpty()) {
                        groupDescription = "Untitled group";
                    }
                    issueDTO.setTitle(groupDescription);
                    issueDTO.setType(null);
                }
                int groupTotalVotes = 0;
                for (VoteElement v : groupElement3.getVoteList()) {
                    groupTotalVotes += v.getVotes();
                }
                issueDTO.setTotalVotes(groupTotalVotes);
                if (groupTotalVotes > 0) {
                    ArrayList<PlayerVoteDTO> playerVoteDTOS = new ArrayList<PlayerVoteDTO>();
                    retroUserKeys = groupElement3.getVoteList().stream().map(votePerGroup -> CONFLUENCE_USER_KEY_PREFIX + votePerGroup.getUserKey()).filter(userKeyWithPrefix -> !retroUserKeyMappings.containsKey(userKeyWithPrefix)).collect(Collectors.toSet());
                    if (!retroUserKeys.isEmpty()) {
                        retroUserKeyMappings.putAll(accessor.getCloudMigrationGateway().getMappingById(transferId, "identity:user", retroUserKeys));
                    }
                    groupElement3.getVoteList().forEach(votePerGroup -> playerVoteDTOS.add(new PlayerVoteDTO((String)retroUserKeyMappings.get(CONFLUENCE_USER_KEY_PREFIX + votePerGroup.getUserKey()), votePerGroup.getVotes())));
                    issueDTO.setPlayerVotes(playerVoteDTOS);
                } else {
                    issueDTO.setPlayerVotes(new ArrayList<PlayerVoteDTO>());
                }
                retroUserKeys = groupElement3.getIdeas().stream().filter(idea -> idea.getUser() != null && idea.getUser().getUserKey() != null).map(idea -> CONFLUENCE_USER_KEY_PREFIX + idea.getUser().getUserKey()).filter(userKeyWithPrefix -> !retroUserKeyMappings.containsKey(userKeyWithPrefix)).collect(Collectors.toSet());
                if (!retroUserKeys.isEmpty()) {
                    retroUserKeyMappings.putAll(accessor.getCloudMigrationGateway().getMappingById(transferId, "identity:user", retroUserKeys));
                }
                ArrayList<NoteDTO> noteDTOS = new ArrayList<NoteDTO>();
                groupElement3.getIdeas().forEach(groupIdea -> noteDTOS.add(new NoteDTO(null, groupIdea.getIdea(), (String)retroUserKeyMappings.get(CONFLUENCE_USER_KEY_PREFIX + groupIdea.getUser().getUserKey()), groupIdea.getColumnId(), null)));
                issueDTO.setNotes(noteDTOS);
                ArrayList<ActionItemDTO> actionItemDTOS = new ArrayList<ActionItemDTO>();
                List<ActionItem> groupActionItems = groupElement3.getActionItems();
                if (groupActionItems != null) {
                    retroUserKeys = groupActionItems.stream().filter(groupActionItem -> groupActionItem.getAssigneeUser() != null && groupActionItem.getAssigneeUser().getUserKey() != null).map(groupActionItem -> CONFLUENCE_USER_KEY_PREFIX + groupActionItem.getAssigneeUser().getUserKey()).filter(userKeyWithPrefix -> !retroUserKeyMappings.containsKey(userKeyWithPrefix)).collect(Collectors.toSet());
                    if (!retroUserKeys.isEmpty()) {
                        retroUserKeyMappings.putAll(accessor.getCloudMigrationGateway().getMappingById(transferId, "identity:user", retroUserKeys));
                    }
                    groupActionItems.forEach(groupActionItem -> {
                        String assigneeUserKey = groupActionItem.getAssigneeUser() == null ? null : groupActionItem.getAssigneeUser().getUserKey();
                        actionItemDTOS.add(new ActionItemDTO(groupActionItem.getDescription(), groupActionItem.getComplete(), (String)retroUserKeyMappings.get(CONFLUENCE_USER_KEY_PREFIX + assigneeUserKey), null));
                    });
                }
                issueDTO.setActionItems(actionItemDTOS);
                issueDTOS.add(issueDTO);
            }
            Collections.sort(issueDTOS, (issue1, issue2) -> issue2.getTotalVotes() - issue1.getTotalVotes());
            retroForCloud.setIssues(issueDTOS);
            BaseUser[] baseUsers = retroSessionData.getBaseUsers();
            if (baseUsers.length > 0) {
                retroUserKeys = Arrays.stream(baseUsers).map(baseUser -> CONFLUENCE_USER_KEY_PREFIX + baseUser.getUserKey()).filter(userKeyWithPrefix -> !retroUserKeyMappings.containsKey(userKeyWithPrefix)).collect(Collectors.toSet());
                if (!retroUserKeys.isEmpty()) {
                    retroUserKeyMappings.putAll(accessor.getCloudMigrationGateway().getMappingById(transferId, "identity:user", retroUserKeys));
                }
                ArrayList<PlayerDTO> playerDTOS = new ArrayList<PlayerDTO>();
                Arrays.stream(baseUsers).forEach(baseUser -> playerDTOS.add(new PlayerDTO((String)retroUserKeyMappings.get(CONFLUENCE_USER_KEY_PREFIX + baseUser.getUserKey()))));
                retroForCloud.setPlayers(playerDTOS);
            } else {
                retroForCloud.setPlayers(new ArrayList<PlayerDTO>());
            }
            retrosForCloud.add(retroForCloud);
        }
        return retrosForCloud;
    }

    private List<ThinkElement> getThinkElementsList(int retroId) {
        return (List)this.activeObjects.executeInTransaction(() -> {
            ThinkElementEntity[] thinkElementEntities;
            ArrayList<ThinkElement> thinkElementList = new ArrayList<ThinkElement>();
            for (ThinkElementEntity thinkElementEntity : thinkElementEntities = (ThinkElementEntity[])this.activeObjects.find(ThinkElementEntity.class, QueryHelper.ByPageId(retroId))) {
                if (thinkElementEntity == null) continue;
                ThinkElement thinkElement = ThinkElementMapper.map(thinkElementEntity);
                thinkElement.setId(thinkElementEntity.getID());
                thinkElementList.add(thinkElement);
            }
            return thinkElementList;
        });
    }

    private SessionData createDefaultSessionData(long uuid) {
        SessionData sessionData = (SessionData)this.activeObjects.executeInTransaction(() -> {
            ActionItemEntity[] actionItemEntities = (ActionItemEntity[])this.activeObjects.find(ActionItemEntity.class, QueryHelper.ByPageId(uuid));
            SessionDataEntity sessionDataEntity = (SessionDataEntity)this.activeObjects.create(SessionDataEntity.class, new DBParam[0]);
            String stringDate = "";
            if (actionItemEntities != null && actionItemEntities.length > 0) {
                stringDate = DateUtil.stringFormat(new Date());
            }
            sessionDataEntity.setPageIdUnlimited("" + uuid);
            sessionDataEntity.setPageId("" + uuid);
            sessionDataEntity.setNumericPageId(uuid);
            sessionDataEntity.setCompletionDate(stringDate);
            sessionDataEntity.setViewName(WAIT_LOCATION);
            sessionDataEntity.setDiscussGroupIndex(0);
            sessionDataEntity.save();
            return SessionDataMapper.map(sessionDataEntity);
        });
        return sessionData;
    }

    static {
        RETROS_LOCATION.put(WAIT_LOCATION, WAIT_LOCATION);
        RETROS_LOCATION.put(THINK_LOCATION, THINK_LOCATION);
        RETROS_LOCATION.put(GROUP_LOCATION, GROUP_LOCATION);
        RETROS_LOCATION.put(VOTE_LOCATION, VOTE_LOCATION);
        RETROS_LOCATION.put(DISCUSS_LOCATION, DISCUSS_LOCATION);
        RETROS_LOCATION.put(ARCHIVED_VIEW, RESULTS_CLOUD_LOCATION);
        RETROS_LOCATION.put(RESULT_VIEW, RESULTS_CLOUD_LOCATION);
    }
}

