(function (angular) {
        angular
            .module('retrospectiveApp')
            .factory('ReadOnlyModePollerService', ReadOnlyModePollerService);

        ReadOnlyModePollerService.$inject = ['IMAGES_BASE_PATH', '$http', '$window', '$interval', '$timeout'];

        function ReadOnlyModePollerService(IMAGES_BASE_PATH, $http, $window, $interval, $timeout) {
            return Poller;


            function Poller(handler, sleep = 180000) {
                this.interval = null;
                this.resolved = true;

                this.start = (stopAfter = 0) => {
                    let counter = 0;
                    console.log('RETROSPECTIVES: Start poll READ ONLY MODE');

                    const resolver = (response, error) => {
                        if (error) {
                            console.log('Error while polling', error);
                        } else {
                            handler(response);
                        }

                        $timeout(() => {
                            this.resolved = true;
                        }, 100);

                        if (stopAfter) {
                            counter++;
                            if (counter == stopAfter) {
                                this.stop();
                            }
                        }
                    };

                    const poll = () => (
                        $http.get(`${IMAGES_BASE_PATH}/rest/api/accessmode`)
                            .then(response => (resolver(response.data === 'READ_ONLY')))
                            .catch(err => (resolver(null, err)))
                    );

                    poll();
                    this.interval = $interval(() => {
                        if (this.resolved) {
                            this.resolved = false;
                            poll();
                        }
                    }, sleep);
                };

                this.stop = () => {
                    console.log('RETROSPECTIVES: Stop poll READ ONLY MODE');
                    $interval.cancel(this.interval);
                };
            }
        }
    }

    (angular)
);