/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.model;

import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.RetrosColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoteCollection {
    private Map<String, List<GroupElement>> groupMap = new HashMap<String, List<GroupElement>>();

    public List<GroupElement> getGroupsByColumnId(String columnId) {
        return this.groupMap.get(columnId);
    }

    public List<GroupElement> getAllGroups() {
        ArrayList<GroupElement> groupElements = new ArrayList<GroupElement>();
        for (String columnId : this.groupMap.keySet()) {
            groupElements.addAll((Collection<GroupElement>)this.groupMap.get(columnId));
        }
        return groupElements;
    }

    public void initializeColumns(RetrosColumn[] columns) {
        for (RetrosColumn column : columns) {
            this.groupMap.put(column.getColumnId(), new ArrayList());
        }
    }

    public void initializeColumns(String[] columnIds) {
        for (String column : columnIds) {
            this.groupMap.put(column, new ArrayList());
        }
    }

    public String[] getColumnIds() {
        return this.groupMap.keySet().toArray(new String[this.groupMap.size()]);
    }
}

