import IBaseStep from "../declarations/IBaseStep";
// steps implementations
import ColumnCreate from "./task/task-create";
import Preferences from "./preferences/preferences";

interface StepConstructor {
    new ($element: JQuery): IBaseStep;
}

type Config = {
    template: string,
    entryClass: StepConstructor,
    nextStep: steps | null,
    previousStep: steps | null
};

export enum steps { task_create = 1, preferences }

declare const require: any;

/**
 *
 * Note. Enum should be forced in typescript, but issue don't allow it
 * https://github.com/Microsoft/TypeScript/issues/13042
 */
const mapping: {[key: string]: Config} = {
     [steps.task_create]: {
         template: require("./task/task-create.html"),
         entryClass: ColumnCreate,
         nextStep: steps.preferences,
         previousStep: null
     },
    [steps.preferences]: {
        template: require("./preferences/preferences.html"),
        entryClass: Preferences,
        nextStep: null,
        previousStep: steps.task_create
    }
};

export default mapping;