/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.servlet;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.SessionData;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.SettingsService;
import com.nearsoft.retrospective.version.LicenseProperties;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class RetrosConfluenceServlet
extends HttpServlet {
    private final SettingsService settingsService;
    private final SessionDataService sessionDataService;
    private final Logger LOG = LoggerFactory.getLogger(RetrosSettings.class);
    private static final String BODY_TEMPLATE = "templates/body.vm";
    private static final String USER_KEY = "userKey";
    private static final String PAGE_ID = "pageId";
    private static final String UUID = "uuid";
    private static final String VALID_LICENSE = "validLicense";
    private static final String SESSION_COMPLETED = "sessionCompleted";
    private static final String COMPLETION_DATE = "completionDate";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMPCSS = "timestampcss";
    private static final String TIMESTAMPJS = "timestampjs";
    private static final String PRESET_MODERATOR = "presetModerator";
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final HostApplication hostApplication;

    @Inject
    public RetrosConfluenceServlet(PluginLicenseManager licenseManager, HostApplication hostApplication, SessionDataService sessionDataService, SettingsService settingsService) {
        this.licenseManager = licenseManager;
        this.hostApplication = hostApplication;
        this.sessionDataService = sessionDataService;
        this.settingsService = settingsService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uuid = req.getParameter(UUID);
        String pageId = req.getParameter(PAGE_ID);
        String contextPath = req.getContextPath();
        long retroId = Long.parseLong(uuid);
        SessionData sessionData = this.sessionDataService.getSessionDataByUUID(retroId);
        RetrosSettings retrosSettings = this.settingsService.getRetrosSettingsById(retroId);
        if (sessionData == null) {
            this.LOG.error("[agile-retrospectives-for-confluence] - Error retrieving and creating new session data with pageId {} and uuid {}", (Object)pageId, (Object)uuid);
            throw new ServletException("The retrospective session can't be found");
        }
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("appId", this.hostApplication.getId().get());
        contextMap.put(PAGE_ID, Encode.forHtml(pageId));
        contextMap.put(USER_KEY, AuthenticatedUserThreadLocal.get().getKey().getStringValue());
        contextMap.put(VALID_LICENSE, this.isLicenseValid());
        contextMap.put(UUID, uuid);
        contextMap.put(SESSION_COMPLETED, sessionData.getViewName().equals("result"));
        contextMap.put(TIMESTAMP, "1722531455865");
        contextMap.put(TIMESTAMPCSS, "1722531455865.css");
        contextMap.put(TIMESTAMPJS, "1722531455865.js");
        contextMap.put(COMPLETION_DATE, this.getCompletionDate(sessionData));
        contextMap.put(PRESET_MODERATOR, retrosSettings.getPresetModeratorUserKey());
        contextMap.put("contextPath", contextPath);
        resp.getWriter().write(VelocityUtils.getRenderedTemplate((String)BODY_TEMPLATE, (Map)contextMap));
    }

    private boolean isLicenseValid() {
        if (LicenseProperties.enabled) {
            return this.licenseManager.getLicense().isDefined() && !((PluginLicense)this.licenseManager.getLicense().get()).getError().isDefined();
        }
        return true;
    }

    private String getCompletionDate(SessionData sessionData) {
        String date = sessionData.getCompletionDate();
        if (date == null || date.isEmpty()) {
            return "";
        }
        return date;
    }
}

