(function (angular) {
    angular
        .module('retrospectiveApp')
        .service('StatefulService', StatefulService);

    function StatefulService() {
        const shared = new State();

        function State() {
            const _state = {};

            this._set = function (key, value) {
                _state[key] = value;
            };

            this._get = function (key) {
                return _state[key];
            }

            this._exists = function(key) {
                return _state.hasOwnProperty(key);
            }
        }

        this.make = function (scope, options = {allowNull: true, allowUndefined: true}) {
            scope.state = new State();

            /*
                use shared object will modify the value for any instance that called Stateful.make(this)
                keep in mind that:

                - The value you set in a place would be changed in another place
                - you should call _set and _get in order to set and get values
             */
            scope.state.shared = shared;

            scope.state.exists = (key) => {
                return scope.state._exists(key);
            };

            scope.state.set = (key, value) => {
                if (key === null || key === undefined) {
                    throw new Error(`Key expected but ${key} provided`);
                }

                if (!options.allowNull && value === null) {
                    throw new Error(`Null values not allowed. Trying to set ${key}`);
                }

                if (!options.allowUndefined && value === undefined) {
                    throw new Error(`Undefined values not allowed. Trying to set ${key}`);
                }

                scope.state._set(key, value);
            };

            scope.state.get = (key, defaultValue = null) => {
                if (!scope.state._exists(key)) {
                    if (defaultValue === null) {
                        throw new Error(`${key} is not in storage`);
                    } else {
                        return defaultValue;
                    }
                }

                return scope.state._get(key);
            }
        }
    }
}(angular));