export type TaskData = {
    id?: string,
    self?: string,
    key?: string,
    summary: string,
    selected?: boolean,
    status?
};

class TasksModel {
    private tasks: Array<TaskData>;
    private type: string; //'jira' | 'created'
    private projectKey: string;

    getProjectKey():string {
        return this.projectKey;
    }

    setProjectKey(key:string):void {
        this.projectKey = key;
    }

    getType():string {
        return this.type;
    }

    setType(type:string):void {
        this.type = type;
    }

    setTasks(tasks: Array<TaskData>) {
        this.tasks = tasks;
    }

    getTasks() {
        return this.tasks;
    }

    removeTask(id: string): Array<TaskData> {
        if (!id) return;
        const task = this.tasks.find((t) => t.id == id);
        if (task) task.selected = false;
    }

    selectTask(id: string) {
        if (!id) return;
        const task = this.tasks.find((t) => t.id == id);
        if (task) task.selected = true;
    }

    getSelectedTasks() {
        return this.tasks.filter((t) => t.selected);
    }

    getSelectedCount() {
        return this.getSelectedTasks().length;
    }

    selectAll() {
        this.tasks.forEach((t) => t.selected = true);
    }

    deleteAll() {
        this.tasks.forEach((t) => t.selected = false);
    }
}

const tasksModel = new TasksModel();
export default tasksModel;
