/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app.tracker;

import com.atlassian.migration.app.tracker.AbstractCloudMigrationListener;
import com.atlassian.migration.app.tracker.BoundCloudMigrationGateway;
import java.util.ArrayList;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CloudMigrationAccessor
implements ServiceTrackerCustomizer {
    public static final String APP_CLOUD_MIGRATION_GATEWAY = "com.atlassian.migration.app.AppCloudMigrationGateway";
    private final ServiceTracker tracker;
    private final BundleContext bundleContext;
    private Collection<RegistrationRequest> listeners = new ArrayList<RegistrationRequest>();
    private BoundCloudMigrationGateway registrar;

    public CloudMigrationAccessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        ServiceTracker tracker = new ServiceTracker(bundleContext, APP_CLOUD_MIGRATION_GATEWAY, (ServiceTrackerCustomizer)this);
        tracker.open();
        this.tracker = tracker;
    }

    public void registerListener(AbstractCloudMigrationListener listener) {
        RegistrationRequest registrationRequest = new RegistrationRequest(listener);
        this.listeners.add(registrationRequest);
        this.sendToRegistrar(registrationRequest);
    }

    public void deregisterListener(AbstractCloudMigrationListener listener) {
        this.listeners.removeIf(it -> it.listener == listener);
        this.removeFromRegistrar(listener);
    }

    public BoundCloudMigrationGateway getCloudMigrationGateway() {
        if (this.registrar == null) {
            throw new RuntimeException("Registrar is not available");
        }
        return this.registrar;
    }

    public Object addingService(ServiceReference serviceReference) {
        try {
            Object service = this.bundleContext.getService(serviceReference);
            this.registrar = new BoundCloudMigrationGateway(service);
            this.listeners.forEach(this::sendToRegistrar);
        }
        catch (NoClassDefFoundError ex) {
            this.registrar = null;
        }
        return this.registrar;
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
    }

    public void removedService(ServiceReference serviceReference, Object o) {
        this.listeners.stream().map(it -> it.listener).forEach(AbstractCloudMigrationListener::onRegistrarRemoved);
        this.registrar = null;
    }

    public void close() {
        this.tracker.close();
    }

    private void sendToRegistrar(RegistrationRequest it) {
        if (this.registrar != null) {
            this.registrar.registerListener(it.listener);
            it.listener.onRegistrationAccepted();
        }
    }

    private void removeFromRegistrar(AbstractCloudMigrationListener it) {
        if (this.registrar != null) {
            this.registrar.deregisterListener(it);
        }
    }

    class RegistrationRequest {
        public final AbstractCloudMigrationListener listener;

        RegistrationRequest(AbstractCloudMigrationListener listener) {
            this.listener = listener;
        }
    }
}

