/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.mappers;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.model.entity.BaseUserEntity;
import com.nearsoft.retrospective.model.entity.SessionUserEntity;
import com.nearsoft.retrospective.model.entity.UserEntity;
import com.nearsoft.retrospective.service.QueryHelper;
import net.java.ao.DBParam;

public class UserMapper {
    public static User map(BaseUserEntity userEntity) {
        User user = new User();
        user.setNumericPageId(userEntity.getNumericPageId());
        user.setPageId(userEntity.getPageId());
        user.setFullName(userEntity.getFullName());
        user.setImageURI(userEntity.getImageUri());
        user.setName(userEntity.getName());
        user.setUserKey(userEntity.getUserKey());
        return user;
    }

    public static BaseUserEntity mapToBaseUserEntity(BaseUserEntity userEntity, User user) {
        userEntity.setFullName(user.getFullName());
        userEntity.setImageUri(user.getImageURI());
        userEntity.setName(user.getName());
        userEntity.setPageId(user.getPageId());
        userEntity.setNumericPageId(user.getNumericPageId());
        userEntity.setUserKey(user.getUserKey());
        return userEntity;
    }

    public static SessionUserEntity mapToSessionUserEntity(ActiveObjects ao, User user) {
        SessionUserEntity userEntity = (SessionUserEntity)ao.create(SessionUserEntity.class, new DBParam[0]);
        return (SessionUserEntity)UserMapper.mapToBaseUserEntity(userEntity, user);
    }

    public static User[] mapMany(BaseUserEntity[] userEntities) {
        User[] users = new User[userEntities.length];
        for (int i = 0; i < userEntities.length; ++i) {
            users[i] = UserMapper.map(userEntities[i]);
        }
        return users;
    }

    public static UserEntity maptoUserEntity(ActiveObjects activeObjects, User user) {
        DatabaseType databaseType = activeObjects.moduleMetaData().getDatabaseType();
        UserEntity[] foundUsers = (UserEntity[])activeObjects.find(UserEntity.class, QueryHelper.ByUserKey(user.getUserKey(), databaseType));
        UserEntity userEntity = foundUsers.length > 0 ? (UserEntity)UserMapper.mapToBaseUserEntity(foundUsers[0], user) : (UserEntity)UserMapper.mapToBaseUserEntity((BaseUserEntity)activeObjects.create(UserEntity.class, new DBParam[0]), user);
        userEntity.save();
        return userEntity;
    }
}

