(function (angular) {
    angular
        .module('retrospectiveApp')
        .directive('retroNotification', ['$interval', retroNotification]);

    function retroNotification($interval) {
        const link = (scope, element) => {
            scope.notifications = [];

            let interval$;

            const notificationCheck = () => {
                scope.notifications = scope.notifications.map((notification) => {
                    notification.old++;
                    return notification;
                }).filter((notification) => {
                    return notification.old < 4;
                });

                if (scope.notifications.length) {
                    try {
                        const notificationsContainer = document.getElementById(`notification-id-${scope.retroId}`);
                        const retro = document.getElementById(scope.retroId);

                        const position = retro.getBoundingClientRect();

                        notificationsContainer.style.top = `${position.y - 40}px`;
                    } catch (err) {

                    }
                }

                if (!scope.notifications.length) {
                    $interval.cancel($interval);
                    interval$ = null;
                }
            };

            scope.$on('SHOW_NOTIFICATION', (evt, data) => {
                scope.notifications.push({
                    type: data.type,
                    title: data.title,
                    message: data.message,
                    old: 0
                });

                if (scope.notifications.length === 1) {
                    interval$ = $interval(notificationCheck, 2000);
                }
            });

            scope.$on('$destroy', () => {
                if ($interval) {
                    $interval.cancel(interval$);
                }
            });

            scope.removeNotification = ($index) => {
                scope.notifications.splice($index, 1);
            };
        };

        return {
            restrict: 'E',
            scope: {
                retroId: '=',
                contextPath: '@',
                timestamp: '='
            },
            link,
            template: `<div id="notification-id-{{retroId}}" class="aui-flags-container retro" ng-if="notifications.length">
                            <div class="aui-flag retro" aria-hidden="false" ng-repeat="notification in notifications">
                                <div class="aui-message aui-message-info closeable shadowed">
                                <div class="retro-notification-icon" ng-switch="notification.type">
                                    <img ng-switch-when="warning" ng-src="{{contextPath}}/download/resources/retrospectives4confluence:retrospective-resources{{timestamp}}/images/notifications/warning.png"/>
                                    <img ng-switch-when="error" ng-src="{{contextPath}}/download/resources/retrospectives4confluence:retrospective-resources{{timestamp}}/images/notifications/error.png"/>
                                    <img ng-switch-when="success" ng-src="{{contextPath}}/download/resources/retrospectives4confluence:retrospective-resources{{timestamp}}/images/notifications/confirm.png"/>
                                    <img ng-switch-when="info" ng-src="{{contextPath}}/download/resources/retrospectives4confluence:retrospective-resources{{timestamp}}/images/notifications/info.png"/>
                                </div>
                                    <span class="title">{{notification.title}}</span> {{notification.message}}
                                    <span class="aui-icon icon-close" role="button" tabindex="0" ng-click="removeNotification($index)"></span>
                                </div>
                           </div>
                       </div>`
        };
    }
}(angular));