/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.nearsoft.retrospective.dto.BaseUserWithModerator;
import com.nearsoft.retrospective.mappers.SessionDataMapper;
import com.nearsoft.retrospective.mappers.UserMapper;
import com.nearsoft.retrospective.model.BaseUser;
import com.nearsoft.retrospective.model.RetrosSettings;
import com.nearsoft.retrospective.model.SessionData;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.model.entity.ActionItemEntity;
import com.nearsoft.retrospective.model.entity.SessionDataEntity;
import com.nearsoft.retrospective.model.entity.SessionUserEntity;
import com.nearsoft.retrospective.model.entity.ThinkElementEntity;
import com.nearsoft.retrospective.service.GroupService;
import com.nearsoft.retrospective.service.QueryHelper;
import com.nearsoft.retrospective.service.RetrospectiveUserService;
import com.nearsoft.retrospective.service.SettingsService;
import com.nearsoft.retrospective.service.ThinkService;
import com.nearsoft.retrospective.service.VoteService;
import com.nearsoft.retrospective.util.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SessionDataService {
    private static final Logger LOGGER = Logger.getLogger((String)SessionDataService.class.getName());
    private final ActiveObjects activeObjects;
    private final RetrospectiveUserService _retrospectiveUserService;
    private final VoteService voteService;
    private final SettingsService _settingsService;
    private final GroupService groupService;
    private final ThinkService thinkService;
    private static final String RESULT_VIEW = "result";
    private static final String ARCHIVED_VIEW = "archived";

    @Autowired
    public SessionDataService(@ComponentImport ActiveObjects activeObjects, VoteService voteService, SettingsService settingsService, RetrospectiveUserService retrospectiveUserService, GroupService groupService, ThinkService thinkService) {
        this.activeObjects = activeObjects;
        this.voteService = voteService;
        this._settingsService = settingsService;
        this._retrospectiveUserService = retrospectiveUserService;
        this.groupService = groupService;
        this.thinkService = thinkService;
    }

    private DatabaseType DATABASE_TYPE() {
        return this.activeObjects.moduleMetaData().getDatabaseType();
    }

    public BaseUserWithModerator getSessionParticipants(long uuid, String view) {
        int i;
        Query query = QueryHelper.ByPageIdAndLastSeen(uuid);
        if (ARCHIVED_VIEW.equals(view) || RESULT_VIEW.equals(view)) {
            query = QueryHelper.ByPageId(uuid);
        }
        SessionUserEntity[] sessionUserEntities = (SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, query);
        RetrosSettings retrosSettings = this._settingsService.getRetrosSettingsById(uuid);
        ArrayList<BaseUser> baseUsers = new ArrayList<BaseUser>();
        int futureModerator = -1;
        BaseUser moderator = null;
        for (i = 0; i < sessionUserEntities.length; ++i) {
            if (!sessionUserEntities[i].getIsModerator()) continue;
            futureModerator = i;
            break;
        }
        for (i = 0; i < sessionUserEntities.length; ++i) {
            SessionUserEntity sessionUserEntity = sessionUserEntities[i];
            BaseUser baseUser = new BaseUser();
            baseUser.setId(sessionUserEntity.getID());
            baseUser.setFullName(sessionUserEntity.getFullName());
            baseUser.setImageUri(sessionUserEntity.getImageUri());
            baseUser.setName(sessionUserEntity.getName());
            baseUser.setPageId(sessionUserEntity.getPageId());
            baseUser.setNumericPageId(sessionUserEntity.getNumericPageId());
            baseUser.setUserKey(sessionUserEntity.getUserKey());
            baseUser.setConnected(sessionUserEntity.getIsConnected());
            baseUser.setModerator(false);
            baseUser.setReady(sessionUserEntity.getIsReady());
            baseUser.setParticipant(sessionUserEntity.getIsParticipant());
            if (futureModerator == -1) {
                if ("RETROS_DYNAMIC_MODERATOR".equals(retrosSettings.getPresetModeratorUserKey())) {
                    if (baseUser.isConnected() && moderator == null) {
                        moderator = baseUser;
                        baseUser.setModerator(true);
                    }
                } else if (baseUser.getUserKey().equals(retrosSettings.getPresetModeratorUserKey())) {
                    moderator = baseUser;
                    baseUser.setModerator(true);
                }
            } else if (i == futureModerator) {
                moderator = baseUser;
                baseUser.setModerator(true);
            }
            if (sessionUserEntity.getIsModerator() != baseUser.isModerator()) {
                sessionUserEntity.setIsModerator(baseUser.isModerator());
                sessionUserEntity.save();
            }
            baseUsers.add(baseUser);
        }
        return new BaseUserWithModerator(baseUsers.toArray(new BaseUser[baseUsers.size()]), moderator, retrosSettings.getPresetModeratorUserKey());
    }

    public SessionData getSessionDataByUUID(long uuid) {
        SessionData sessionData = new SessionData();
        SessionDataEntity[] sessionDataEntities = (SessionDataEntity[])this.activeObjects.executeInTransaction(() -> (SessionDataEntity[])this.activeObjects.find(SessionDataEntity.class, QueryHelper.ByPageId(uuid)));
        sessionData = sessionDataEntities.length > 0 ? SessionDataMapper.map(sessionDataEntities[0]) : this.createDefaultSessionData(uuid);
        BaseUserWithModerator participantsWithModerator = this.getSessionParticipants(uuid, sessionData.getViewName());
        sessionData.setParticipants(participantsWithModerator.getParticipants());
        sessionData.setModerator(participantsWithModerator.getModerator());
        sessionData.setPresetModeratorUserKey(participantsWithModerator.getPresetModeratorUserKey());
        return sessionData;
    }

    private SessionData createDefaultSessionData(long uuid) {
        SessionData sessionData = (SessionData)this.activeObjects.executeInTransaction(() -> {
            ActionItemEntity[] actionItemEntities = (ActionItemEntity[])this.activeObjects.find(ActionItemEntity.class, QueryHelper.ByPageId(uuid));
            SessionDataEntity sessionDataEntity = (SessionDataEntity)this.activeObjects.create(SessionDataEntity.class, new DBParam[0]);
            String stringDate = "";
            if (actionItemEntities != null && actionItemEntities.length > 0) {
                stringDate = DateUtil.stringFormat(new Date());
            }
            sessionDataEntity.setPageIdUnlimited(uuid + "");
            sessionDataEntity.setPageId(uuid + "");
            sessionDataEntity.setNumericPageId(uuid);
            sessionDataEntity.setCompletionDate(stringDate);
            sessionDataEntity.setViewName("wait");
            sessionDataEntity.setDiscussGroupIndex(0);
            sessionDataEntity.save();
            return SessionDataMapper.map(sessionDataEntity);
        });
        return sessionData;
    }

    public SessionData setView(long uuid, String viewName) {
        SessionUserEntity[] users;
        ThinkElementEntity[] ideas;
        SessionData sessionData = this.getSessionDataByUUID(uuid);
        String preViewName = sessionData.getViewName();
        sessionData.setViewName(viewName);
        if (viewName.equals(RESULT_VIEW) && (sessionData.getCompletionDate() == null || sessionData.getCompletionDate().isEmpty())) {
            String formattedDate = DateUtil.stringFormat(new Date());
            sessionData.setCompletionDate(formattedDate);
        }
        if (viewName.equals(RESULT_VIEW) && (ideas = (ThinkElementEntity[])this.activeObjects.find(ThinkElementEntity.class, QueryHelper.ByPageId(uuid))) != null && ideas.length > 0) {
            for (ThinkElementEntity idea : ideas) {
                idea.setEditable(false);
                idea.save();
            }
        }
        if (preViewName.equals("think") && !viewName.equals("group")) {
            this.groupService.processNonGroupedIdeas(uuid, this.thinkService.getThinkElementsList(uuid));
        } else if (preViewName.equals("group") && !viewName.equals("think")) {
            this.groupService.processNonGroupedIdeas(uuid, this.thinkService.getThinkElementsList(uuid));
        }
        if (viewName.equals("vote")) {
            this.voteService.initializeForSession(uuid);
        }
        if (viewName.equals("discuss") || viewName.equals("group")) {
            this.voteService.finalizeForSession(uuid);
        }
        if ((users = (SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, QueryHelper.ByPageId(uuid))) != null) {
            for (SessionUserEntity user : users) {
                user.setIsReady(false);
                user.save();
            }
        }
        return this.persistSessionData(uuid, sessionData);
    }

    public SessionData persistSessionData(long uuid, SessionData sessionData) {
        SessionDataEntity[] sessionDataEntityList;
        for (SessionDataEntity entity : sessionDataEntityList = (SessionDataEntity[])this.activeObjects.find(SessionDataEntity.class, QueryHelper.ByPageId(uuid))) {
            this.activeObjects.delete(new RawEntity[]{entity});
        }
        SessionDataEntity sessionDataEntity = (SessionDataEntity)this.activeObjects.create(SessionDataEntity.class, new DBParam[0]);
        sessionDataEntity.setPageIdUnlimited(uuid + "");
        sessionDataEntity.setPageId(uuid + "");
        sessionDataEntity.setNumericPageId(uuid);
        sessionDataEntity.setCompletionDate(sessionData.getCompletionDate());
        sessionDataEntity.setViewName(sessionData.getViewName());
        sessionDataEntity.setDiscussGroupIndex(sessionData.getDiscussGroupIndex());
        sessionDataEntity.save();
        return SessionDataMapper.map(sessionDataEntity);
    }

    public void setUserAsParticipant(long pageId, String userKey) {
        SessionUserEntity userEntity = Arrays.stream((SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, QueryHelper.ByPageIdAndUserKey(pageId, userKey, this.DATABASE_TYPE()))).findFirst().orElse(null);
        if (userEntity != null) {
            userEntity.setIsParticipant(true);
            userEntity.save();
        }
    }

    public void nextTopic(long uuid, int limit) {
        SessionData sessionData = this.getSessionDataByUUID(uuid);
        if (sessionData.getDiscussGroupIndex() + 1 <= limit) {
            sessionData.setDiscussGroupIndex(sessionData.getDiscussGroupIndex() + 1);
            this.persistSessionData(uuid, sessionData);
        }
    }

    public void previousTopic(long uuid) {
        SessionData sessionData = this.getSessionDataByUUID(uuid);
        if (sessionData.getDiscussGroupIndex() > 0) {
            sessionData.setDiscussGroupIndex(sessionData.getDiscussGroupIndex() - 1);
            this.persistSessionData(uuid, sessionData);
        }
    }

    public void reopen(long uuid) {
        SessionData sessionData = this.getSessionDataByUUID(uuid);
        sessionData.setViewName("think");
        this.persistSessionData(uuid, sessionData);
    }

    public void setModerator(String userKey, long uuid) {
        SessionUserEntity[] existentUsers = (SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, QueryHelper.ByPageId(uuid));
        if (existentUsers != null) {
            for (SessionUserEntity sessionUserEntity : existentUsers) {
                sessionUserEntity.setIsModerator(sessionUserEntity.getUserKey().equals(userKey));
                sessionUserEntity.save();
            }
            this._settingsService.updatePresetModeratorForRetrosSettingsById(uuid, userKey);
        }
    }

    public void setUserAsDisconnected(String userKey, long uuid) {
        this.changeUserConnectionStatus(userKey, uuid, false);
    }

    public void setUserAsConnected(String userKey, long uuid) {
        this.changeUserConnectionStatus(userKey, uuid, true);
    }

    private void changeUserConnectionStatus(String userKey, long uuid, boolean connected) {
        SessionUserEntity[] existentUsers = (SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, QueryHelper.ByPageIdAndUserKey(uuid, userKey, this.DATABASE_TYPE()));
        if (existentUsers == null || existentUsers.length == 0) {
            User newUser = this._retrospectiveUserService.makeRetrospectiveUser(this.getConfluenceUser());
            newUser.setPageId(uuid + "");
            newUser.setNumericPageId(uuid);
            SessionUserEntity userEntity = UserMapper.mapToSessionUserEntity(this.activeObjects, newUser);
            userEntity.setIsParticipant(false);
            userEntity.setIsConnected(connected);
            userEntity.save();
        } else {
            for (SessionUserEntity sessionUserEntity : existentUsers) {
                sessionUserEntity.setIsConnected(connected);
                sessionUserEntity.save();
            }
        }
    }

    public void hearthbeat(String userKey, long uuid) {
        Date now = new Date();
        SessionUserEntity[] existentUsers = (SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, QueryHelper.ByPageIdAndUserKey(uuid, userKey, this.DATABASE_TYPE()));
        if (existentUsers == null || existentUsers.length == 0) {
            User newUser = this._retrospectiveUserService.makeRetrospectiveUser(this.getConfluenceUser());
            newUser.setPageId(uuid + "");
            newUser.setNumericPageId(uuid);
            SessionUserEntity userEntity = UserMapper.mapToSessionUserEntity(this.activeObjects, newUser);
            userEntity.setLastSeen(now.getTime());
            userEntity.save();
        } else {
            for (SessionUserEntity sessionUserEntity : existentUsers) {
                sessionUserEntity.setLastSeen(now.getTime());
                sessionUserEntity.save();
            }
        }
    }

    public void toggleIsReadyByUserKeyAndPageId(String userKey, long pageId) {
        SessionUserEntity[] users = (SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, QueryHelper.ByPageIdAndUserKey(pageId, userKey, this.DATABASE_TYPE()));
        if (users != null && users.length != 0) {
            SessionUserEntity user;
            user.setIsReady(!(user = users[0]).getIsReady());
            user.save();
        }
    }

    public User getUserByPageIdOrCreate(long retrospectiveIdentifier) {
        return this.createUser(retrospectiveIdentifier);
    }

    private User createUser(long pageId) {
        User newUser = this._retrospectiveUserService.makeRetrospectiveUser(this.getConfluenceUser());
        if (newUser == null) {
            return null;
        }
        newUser.setNumericPageId(pageId);
        newUser.setPageId(pageId + "");
        this.saveUserIntoDB(newUser);
        return newUser;
    }

    private void saveUserIntoDB(User newUser) {
        SessionUserEntity[] existentUsers = (SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, QueryHelper.ByPageIdAndUserKey(newUser.getNumericPageId(), newUser.getUserKey(), this.DATABASE_TYPE()));
        if (existentUsers == null || existentUsers.length == 0) {
            SessionUserEntity userEntity = UserMapper.mapToSessionUserEntity(this.activeObjects, newUser);
            userEntity.setIsParticipant(false);
            userEntity.setIsConnected(true);
            userEntity.setIsReady(newUser.getIsReady());
            userEntity.save();
        }
    }

    public ConfluenceUserImpl getConfluenceUser() {
        ConfluenceUserImpl user = null;
        try {
            user = (ConfluenceUserImpl)AuthenticatedUserThreadLocal.get();
        }
        catch (NullPointerException npe) {
            LOGGER.warn((Object)"Couldn't get user from authenticated thread");
        }
        return user;
    }

    public List<SessionData> getSessionDatas() {
        SessionDataEntity[] sessionDataEntities = (SessionDataEntity[])this.activeObjects.find(SessionDataEntity.class);
        ArrayList<SessionData> sessionDatas = new ArrayList<SessionData>();
        for (SessionDataEntity entity : sessionDataEntities) {
            SessionData sessionData = SessionDataMapper.map(entity);
            if (sessionDatas.contains(sessionData)) continue;
            sessionDatas.add(sessionData);
        }
        return sessionDatas;
    }
}

