(function (angular) {
    angular
        .module('retrospectiveApp')
        .factory('TopicService', TopicService);

    TopicService.$inject = ['HTTP_PATH', '$http', '$rootScope'];

    function TopicService(HTTP_PATH, $http, $rootScope) {

        const get = ({uuid}) => $http.get(`${HTTP_PATH}/topics?uuid=${uuid}`)
            .then(response => response.data)
            .catch(console.error);

        const notifyChangeTopic = ({userKey, uuid, index}) => $http.put(`${HTTP_PATH}/workflow/change-topic?userKey=${userKey}&uuid=${uuid}&currentTopicIndex=${index}`)
            .then(response => response.data)
            .catch(console.error);

        const create = ({userKey, uuid, data}) => $http.post(`${HTTP_PATH}/workflow/action-item?userKey=${userKey}&uuid=${uuid}`, data)
            .then(response => response.data)
            .catch(console.error);

        return {
            get,
            notifyChangeTopic,
            create
        };
    }
}(angular));