(function (angular) {
    angular
        .module('retrospectiveApp')
        .factory('performanceTracker', [function() {
            const transactions = {};
            const stats = [];
            const requestKeys = {};

            function compileStats() {
                const keys = Object.keys(requestKeys);
                const byKey = {};

                keys.forEach(key => {
                    const statsByKey = stats.filter(s => s.key == key);

                    byKey[key] = {
                        count: statsByKey.length,
                        avg: statsByKey.reduce((a,b) => a + b.timeTaken, 0) / statsByKey.length
                    }
                });

                console.log(byKey);
                console.log(JSON.stringify(byKey));
            }

            function pushToStats(key) {
                requestKeys[key] = 0;
                stats.push({
                    key,
                    timeTaken: transactions[key].finalTime - transactions[key].initialTime
                });
            }

            const logTimeTaken = {
                request: (config) => {
                    const key = `${config.url.split('?')[0]}:${config.method}`;

                    transactions[key] = {
                        initialTime: new Date().getTime()
                    };
                    //config.requestTimestamp = new Date().getTime();
                    return config;
                },
                response: (response) => {
                    const key = `${response.config.url.split('?')[0]}:${response.config.method}`;

                    transactions[key] = {
                        ...transactions[key],
                        finalTime: new Date().getTime()
                    };

                    pushToStats(key);

                    /**
                     * Print stats on re-open event
                     */
                    if (response.config.url.indexOf('/workflow/reopen') >= 0) {
                        compileStats();
                    }

                    //response.config.responseTimestamp = new Date().getTime();
                    //console.log(response, response.config.responseTimestamp);
                    return response;
                }
            };
            return logTimeTaken;
        }]);

}(angular));