(function (angular) {
    angular
        .module('retrospectiveApp')
        .service('GroupsService', GroupsService);

    GroupsService.$inject = ['HTTP_PATH', '$http', 'SubscribableService', 'StatefulService', 'PollerService'];

    function GroupsService(HTTP_PATH, $http, Subscribable, Stateful, Poller) {
        Subscribable.make(this);

        Stateful.make(this, {
            allowNull: false,
            allowUndefined: false
        });

        this.groupsPoller = null;
        this.groupedIdeaPoller = null;

        this.stopPoller = () => {
            if (!this.groupsPoller) {
                return;
            }

            this.groupsPoller.stop();

            if (!this.groupedIdeaPoller) {
                return;
            }

            this.groupedIdeaPoller.stop();

            this.groupsPoller = null;
            this.groupedIdeaPoller = null;
        };

        this.startPollers = (userKey, uuid, interval) => {
            if (this.groupsPoller) {
                return;
            }

            this.state.set('groupListHash', '');
            this.state.set('userKey', userKey);
            this.state.set('uuid', uuid);

            this.groupedIdeaPoller = new Poller(`/group/current?uuid=${this.state.get('uuid')}`, (response) => {
                this.notify({
                   identifier: 'groupedIdea',
                    state: {
                        groupedIdea: response.data ||  {
                            name: '',
                            ids: []
                        }
                    }
                });

            }, interval);

            this.groupsPoller = new Poller(`/group?uuid=${this.state.get('uuid')}`, (response) => {
                if (!response.data) {
                    return;
                }

                // TODO hacer que devuelva collection
                const groupListHash = response.data.groupList.reduce((a, c) =>
                    `${a},${(c.ideas || []).length},${c.description}`, '');
                const stored = this.state.get('groupListHash', '');

                // TODO compare with state to avoid perpetual refresh
                if (groupListHash !== stored) {
                    this.state.set('groupListHash', groupListHash);

                    this.notify({
                        identifier: 'groupList',
                        state: { groupList: response.data.groupList.map((item) => {
                            if (!item.ideas) {
                                item.ideas = [];
                            }
                            return item;
                        }) }
                    });
                }
            }, interval);

            this.groupsPoller.start();
            this.groupedIdeaPoller.start();
        };

        this.addIdeaToGroupedIdea = (idea) => {
            return $http.put(`${HTTP_PATH}/group/idea?uuid=${this.state.get('uuid')}`, {thinkElement: idea})
                .then(() => {
                    this.groupsPoller.poll()
                    this.groupedIdeaPoller.poll()
                })
        };

        this.removeIdeaFromGroupedIdea = (idea) => {
            return $http.delete(`${HTTP_PATH}/group/idea/${idea.id}?uuid=${this.state.get('uuid')}`)
                .then(() => {
                    this.groupsPoller.poll()
                    this.groupedIdeaPoller.poll()
                })
        };

        this.createGroupedIdea = (idea) => {
            return $http.post(`${HTTP_PATH}/group/idea?uuid=${this.state.get('uuid')}`, {thinkElement: idea})
                .then(() => {
                    this.groupsPoller.poll()
                    this.groupedIdeaPoller.poll()
                })
        };

        this.editGroupName = (name) => {
            return $http.put(`${HTTP_PATH}/group/idea/name?uuid=${this.state.get('uuid')}`,{name})
                .then(() => {
                    this.groupsPoller.poll()
                    this.groupedIdeaPoller.poll()
                })
        };

        // should this affect the GroupResponse ?
        this.saveGroup = () => {
            return $http.post(`${HTTP_PATH}/group?uuid=${this.state.get('uuid')}`)
                .then(() => {
                    this.groupsPoller.poll()
                    this.groupedIdeaPoller.poll()
                })
        };

        this.editGroup = (group) => {
            return $http.put(`${HTTP_PATH}/group/${group.id}?uuid=${this.state.get('uuid')}`)
                .then(() => {
                    this.groupsPoller.poll()
                    this.groupedIdeaPoller.poll()
                })
        };

        this.breakGroup = () => {
            return $http.delete(`${HTTP_PATH}/group?uuid=${this.state.get('uuid')}`)
                .then(() => {
                    this.groupsPoller.poll()
                    this.groupedIdeaPoller.poll()
                })
        };

    }
}(angular));
