function cancel() {
    history.back();
}

function tryGetBase() {
    const baseUrl = window.location.origin + window.location.pathname;

    // we enter using the confluence UI
    if (baseUrl.indexOf('/display') >= 0) {
        return baseUrl.split('/display')[0];
    }
    // we enter by copy and paste a url
    else if (baseUrl.indexOf('/pages') >= 0) {
        return baseUrl.split('/pages')[0];
    }
    else if (baseUrl.indexOf('/plugins') >= 0) {
        return baseUrl.split('/plugins')[0];
    }
    // we'll use default value
    else {
        return null;
    }
}

function getBaseUrl() {
    const url = tryGetBase();
    return url ? url : '/confluence';
}

function saveChanges() {
    const baseUrl = getBaseUrl();
    const url = baseUrl + '/rest/retrospective/latest/configure';
    const sessionInterval = $('#sessionInterval').val();
    const summaryInterval = $('#summaryInterval').val();
    const summaryStopAfter = $('#summaryStopAfter').val();
    $.ajax({
        url: url,
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({
            sessionInterval: sessionInterval,
            summaryInterval: summaryInterval,
            summaryStopAfter: summaryStopAfter
        }),
        success: function() {
            const flag = AJS.flag({
                type: "success",
                body: '<div><img src="'+checkUrl+'" class="flagIcon"/>Your changes have been saved.</div>'
            });
            setTimeout(() => {
                flag.close();
            }, 10000);
        },
        error: function(error) {
            console.error('error saving global settings', error);
        }

    });
}

(function($) {
    $(document).ready(function() {
        const baseUrl = getBaseUrl();
        const url = baseUrl + '/rest/retrospective/latest/configure';
        AJS.$("#globalTooltip").tooltip({gravity: 'sw'});
        $.ajax({
            url: url,
            type: 'GET',
            contentType: 'application/json',
            success: function(response) {
                $('#sessionInterval').val(response.sessionInterval);
                $('#summaryInterval').val(response.summaryInterval);
                $('#summaryStopAfter').val(response.summaryStopAfter);
            },
            error: function(error) {
                console.error('error getting global settings', error);
            },
    
        });
        $('#cancel').click(cancel);
        $('#back').click(cancel);
        $('#save').click(saveChanges);
        $('.settingsTable').removeClass('hidden');
        $('#reset').click(function(){
            $('#sessionInterval').val(1);
            $('#summaryInterval').val(30);
            $('#summaryStopAfter').val(5);
            validateAllInputs();
        });

        $('.inputTime').keyup(function(){
            validateAllInputs();
        }).change(function(){
            validateAllInputs();
        }).click(function(){
            validateAllInputs();
        });

        const validateAllInputs = function(){
            validateInput('#sessionInterval');
            validateInput('#summaryInterval');
            validateInput('#summaryStopAfter');
        }

        const validateInput = function(inputId){
            const element = $(inputId);
            const errorMinElement = $(`${inputId}ErrorMin`);
            const errorMaxElement = $(`${inputId}ErrorMax`);
            element.removeClass('error');
            errorMinElement.addClass('hidden');
            errorMaxElement.addClass('hidden');
            if(element.val() < 1){
                element.addClass('error');
                errorMinElement.removeClass('hidden');
                $('#save').attr('disabled', 'disabled')
            }else if(element.val() > 60){
                element.addClass('error');
                errorMaxElement.removeClass('hidden');
                $('#save').attr('disabled', 'disabled')
            }
            enableOrDisableSave();

        };

        const enableOrDisableSave = function(){
            const inputsWithErrors = $('input.error');
            if(inputsWithErrors.length > 0){
                $('#save').attr('disabled', 'disabled');
            }else{
                $('#save').removeAttr('disabled');
            }
        }
    });
})(jQuery)
