/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nearsoft.retrospective.model.GlobalSettings;
import com.nearsoft.retrospective.securityControl.PermissionValidator;
import com.nearsoft.retrospective.service.ConfigureService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/configure")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class ConfigureResource {
    private static final Gson GSON = new Gson();
    private final ConfigureService configureService;
    private final PermissionValidator permissionValidator;

    @Autowired
    public ConfigureResource(ConfigureService configureService, PermissionValidator permissionValidator) {
        this.configureService = configureService;
        this.permissionValidator = permissionValidator;
    }

    @POST
    public Response saveGlobalSettings(String json) throws Exception {
        this.permissionValidator.isConfluenceAdmin();
        JsonElement jelem = GSON.fromJson(json, JsonElement.class);
        JsonObject jsonObject = jelem.getAsJsonObject();
        int sessionInterval = jsonObject.get("sessionInterval").getAsInt();
        int summaryInterval = jsonObject.get("summaryInterval").getAsInt();
        int summaryStopAfter = jsonObject.get("summaryStopAfter").getAsInt();
        this.configureService.saveGlobalSettings(sessionInterval, summaryInterval, summaryStopAfter);
        return Response.ok((Object)GSON.toJson("updated")).build();
    }

    @GET
    public Response getGlobalSettings() throws Exception {
        this.permissionValidator.isConfluenceAdmin();
        GlobalSettings globalSettings = this.configureService.getGlobalSettings();
        return Response.ok((Object)GSON.toJson(globalSettings)).build();
    }
}

