(function (angular) {
    angular
        .module('retrospectiveApp')
        .factory('PollerService', PollerService);

    PollerService.$inject = ['HTTP_PATH', '$http', '$interval', '$timeout'];

    function PollerService(HTTP_PATH, $http, $interval, $timeout) {
        return Poller;

        /*
         helper for polling. instantiate it to start a new interval that will be
         polling until you stop it
         */
        function Poller(url, handler, sleep = 1000) {
            this.interval = null;
            this.identifier = '';
            this.resolved = true;

            this.setIdentifier = (id) => this.identifier = id;

            this.start = (stopAfter = 0) => {
                let counter = 0;
                console.log(`RETROSPECTIVES: Start poll ${this.identifier} for url ${url}`);

                const resolver = (response, error) => {
                    if (error) {
                        console.log('Error while polling', this.identifier, error);
                    } else {
                        handler(response);
                    }

                    $timeout(() => {
                        this.resolved = true;
                    }, 100);

                    if (stopAfter) {
                        // counter++;
                        // if (counter == stopAfter) {
                        counter+=sleep;
                        if (counter >= stopAfter) {
                            this.stop();
                        }
                    }
                };

                const poll = () => $http.get(`${HTTP_PATH}${url}`)
                    .then(resolver)
                    .catch((err) => resolver(null, err));

                console.log('constructor')
                this.interval = $interval(() => {
                    console.log('interval')
                    if (this.resolved) {
                        this.resolved = false;
                        poll();
                    }
                }, sleep);
                poll();
                console.log('after interval')
            };

            this.stop = () => {
                console.log(`RETROSPECTIVES: Stop poll ${this.identifier} for url ${url}`);

                $interval.cancel(this.interval);
            };
        }
    }
}(angular));