/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.model.entity.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.nearsoft.retrospective.mappers.GroupElementMapper;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.entity.GroupElementEntity;
import com.nearsoft.retrospective.model.entity.SessionDataEntity;
import com.nearsoft.retrospective.model.entity.ThinkElementEntity;
import com.nearsoft.retrospective.service.QueryHelper;

public class SessionDataEntityUpgrade002
implements ActiveObjectsUpgradeTask {
    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"8");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        ao.migrate(new Class[]{SessionDataEntity.class});
        for (SessionDataEntity sessionDataEntity : (SessionDataEntity[])ao.find(SessionDataEntity.class)) {
            if (!sessionDataEntity.getCompletionDate().trim().equals("")) {
                sessionDataEntity.setViewName("result");
            } else {
                String view = this.findView(ao, sessionDataEntity.getNumericPageId());
                sessionDataEntity.setViewName(view);
            }
            if (sessionDataEntity.getPageId() == null || sessionDataEntity.getPageId().isEmpty() && !sessionDataEntity.getPageIdUnlimited().isEmpty()) {
                sessionDataEntity.setPageId(sessionDataEntity.getPageIdUnlimited());
            }
            sessionDataEntity.save();
        }
    }

    private String findView(ActiveObjects ao, long uuid) {
        ThinkElementEntity[] thinkElementEntities = (ThinkElementEntity[])ao.find(ThinkElementEntity.class, QueryHelper.ByPageId(uuid));
        boolean hasIdea = thinkElementEntities.length > 0;
        GroupElementEntity[] groupElementEntities = (GroupElementEntity[])ao.find(GroupElementEntity.class, QueryHelper.ByPageId(uuid));
        boolean hasGroups = groupElementEntities.length > 0;
        boolean hasVotes = false;
        boolean hasActionItems = false;
        for (GroupElementEntity groupElement : groupElementEntities) {
            GroupElement group = GroupElementMapper.map(groupElement);
            if (group.getVotes() != 0) {
                hasVotes = true;
            }
            if (group.getActionItems().size() == 0) continue;
            hasActionItems = true;
            break;
        }
        if (hasActionItems) {
            return "discuss";
        }
        if (hasVotes) {
            return "vote";
        }
        if (hasGroups) {
            return "group";
        }
        if (hasIdea) {
            return "think";
        }
        return "";
    }
}

